/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.port;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.oauth.DbxCredential;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.common.PathRoot;
import com.dropbox.core.v2.users.FullAccount;
import com.nodepit.knime.dropbox.Constants;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import java.util.Optional;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.ModelContentRO;
import org.knime.core.node.ModelContentWO;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.AbstractSimplePortObjectSpec;

public class DropboxConnector2PortObjectSpec
extends AbstractDropboxConnectorPortObjectSpec {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(DropboxConnector2PortObjectSpec.class);
    private static final String KEY_ACCESS_TOKEN = "accessToken";
    private static final String KEY_EXPIRES_AT = "expiresAt";
    private static final String KEY_REFRESH_TOKEN = "refreshToken";
    private String accessToken;
    private Long expiresAt;
    private String refreshToken;
    private DbxClientV2 client;

    public DropboxConnector2PortObjectSpec() {
    }

    public DropboxConnector2PortObjectSpec(String accessToken, Long expiresAt, String refreshToken) {
        this.accessToken = accessToken;
        this.expiresAt = expiresAt;
        this.refreshToken = refreshToken;
    }

    protected void save(ModelContentWO model) {
        model.addString(KEY_ACCESS_TOKEN, this.accessToken);
        model.addLong(KEY_EXPIRES_AT, Optional.ofNullable(this.expiresAt).orElse(-1L).longValue());
        model.addString(KEY_REFRESH_TOKEN, this.refreshToken);
    }

    protected void load(ModelContentRO model) throws InvalidSettingsException {
        this.accessToken = model.getString(KEY_ACCESS_TOKEN);
        long expiresAtPrimitive = model.getLong(KEY_EXPIRES_AT, -1L);
        this.expiresAt = expiresAtPrimitive != -1L ? Long.valueOf(expiresAtPrimitive) : null;
        this.refreshToken = model.getString(KEY_REFRESH_TOKEN);
    }

    @Override
    public DbxClientV2 getClient() throws DbxException {
        if (this.client == null) {
            this.client = this.initClient();
        }
        return this.client;
    }

    private DbxClientV2 initClient() throws DbxApiException, DbxException {
        DbxRequestConfig config = DbxRequestConfig.newBuilder((String)Constants.CLIENT_IDENTIFIER).build();
        DbxCredential credential = new DbxCredential(this.accessToken, this.expiresAt, this.refreshToken, "ahviff37pooa3cn", "4yio7bp0i7c2fnk");
        DbxClientV2 client = new DbxClientV2(config, credential);
        FullAccount account = client.users().getCurrentAccount();
        String rootNamespaceId = account.getRootInfo().getRootNamespaceId();
        LOGGER.debugWithFormat("Using path root %s", new Object[]{rootNamespaceId});
        client = client.withPathRoot(PathRoot.namespaceId((String)rootNamespaceId));
        return client;
    }

    public static class Serializer
    extends AbstractSimplePortObjectSpec.AbstractSimplePortObjectSpecSerializer<DropboxConnector2PortObjectSpec> {
    }
}

