/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.rename;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import com.nodepit.knime.dropbox.rename.DropboxRenameNodeModel;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;

class DropboxRenameNodeDialog
extends DefaultNodeSettingsPane {
    private final SettingsModelString settingsModelPath = DropboxRenameNodeModel.createSettingsModelPath();
    private final SettingsModelString settingsModelNewName = DropboxRenameNodeModel.createSettingsModelNewName();
    private final DialogComponentDbxPath pathChooser;

    DropboxRenameNodeDialog() {
        FlowVariableModel fvPathModel = this.createFlowVariableModel("path", FlowVariable.Type.STRING);
        this.pathChooser = new DialogComponentDbxPath(this.settingsModelPath, "File/Folder Path", DropboxPicker.NodeType.FILE_OR_FOLDER, fvPathModel);
        this.addDialogComponent(this.pathChooser);
        FlowVariableModel fvNewNameModel = this.createFlowVariableModel("newName", FlowVariable.Type.STRING);
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settingsModelNewName, "New Name", true, 30, fvNewNameModel));
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPathNotRoot(this.settingsModelPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.pathChooser.loadSettings(spec);
    }
}

