/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.dropbox.search;

import com.nodepit.knime.dropbox.DialogComponentDbxPath;
import com.nodepit.knime.dropbox.DropboxPicker;
import com.nodepit.knime.dropbox.Utils;
import com.nodepit.knime.dropbox.port.AbstractDropboxConnectorPortObjectSpec;
import com.nodepit.knime.dropbox.search.DropboxSearchNodeModel;
import org.knime.core.node.FlowVariableModel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.workflow.FlowVariable;

class DropboxSearchNodeDialog
extends DefaultNodeSettingsPane {
    private final SettingsModelString settingsModelPath = DropboxSearchNodeModel.createSettingsModelPath();
    private final SettingsModelString settingsModelQuery = DropboxSearchNodeModel.createSettingsModelQuery();
    private final DialogComponentDbxPath remotePathChooser;

    DropboxSearchNodeDialog() {
        FlowVariableModel fvModelPath = this.createFlowVariableModel("path", FlowVariable.Type.STRING);
        this.remotePathChooser = new DialogComponentDbxPath(this.settingsModelPath, "Remote Search Path", DropboxPicker.NodeType.FOLDER, fvModelPath);
        this.addDialogComponent(this.remotePathChooser);
        FlowVariableModel fvModelQuery = this.createFlowVariableModel("query", FlowVariable.Type.STRING);
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settingsModelQuery, "Query", true, 30, fvModelQuery));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(DropboxSearchNodeModel.createSettingsModelAllProperties(), "Return All Properties"));
    }

    public void saveAdditionalSettingsTo(NodeSettingsWO settings) throws InvalidSettingsException {
        super.saveAdditionalSettingsTo(settings);
        Utils.validateDropboxPath(this.settingsModelPath.getStringValue());
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        super.loadAdditionalSettingsFrom(settings, specs);
        AbstractDropboxConnectorPortObjectSpec spec = (AbstractDropboxConnectorPortObjectSpec)specs[0];
        this.remotePathChooser.loadSettings(spec);
    }
}

