/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.console;

import java.util.Optional;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.node.console.ConsoleSettings;
import me.danielesser.knime.elasticsearch.es8.port.Connection;
import me.danielesser.knime.elasticsearch.es8.port.ConnectionPortObject;
import me.danielesser.knime.elasticsearch.es8.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractNodeModel;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.LicenseChecker;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class ConsoleNodeModel
extends AbstractNodeModel<ConsoleSettings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ConsoleNodeModel.class);

    public ConsoleNodeModel() {
        super(new PortType[]{ConnectionPortObject.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE}, (AbstractSettings)new ConsoleSettings());
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        Optional<Connection> connection = PortHelper.getConnection(inSpecs);
        if (!connection.isPresent()) {
            ((ConsoleSettings)this.getSettings()).validate(inSpecs);
        }
        return new DataTableSpec[]{this.createDataTableSpec()};
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        LicenseChecker.getLicense();
        Optional<Connection> connectionOptional = PortHelper.getConnection(inData);
        if (connectionOptional.isPresent()) {
            Connection connection = connectionOptional.get();
            return this.request(exec, connection.getProtocol(), connection.getHost(), connection.getPort(), connection.getUsername(this.getCredentialsProvider()), connection.getPassword(this.getCredentialsProvider()), connection.getAcceptAllCerts(), ((ConsoleSettings)this.getSettings()).getMethod().getStringValue(), ((ConsoleSettings)this.getSettings()).getEndpoint().getStringValue(), ((ConsoleSettings)this.getSettings()).getBody().getStringValue());
        }
        return this.request(exec, ((ConsoleSettings)this.getSettings()).getProtocol().getStringValue(), ((ConsoleSettings)this.getSettings()).getHost().getStringValue(), ((ConsoleSettings)this.getSettings()).getPort().getIntValue(), ((ConsoleSettings)this.getSettings()).getAuth().getUserName(this.getCredentialsProvider()), ((ConsoleSettings)this.getSettings()).getAuth().getPassword(this.getCredentialsProvider()), ((ConsoleSettings)this.getSettings()).getAcceptAllCerts().getBooleanValue(), ((ConsoleSettings)this.getSettings()).getMethod().getStringValue(), ((ConsoleSettings)this.getSettings()).getEndpoint().getStringValue(), ((ConsoleSettings)this.getSettings()).getBody().getStringValue());
    }

    private BufferedDataTable[] request(ExecutionContext exec, String protocol, String host, int port, String username, String password, boolean acceptAllCerts, String method, String endpoint, String body) throws Exception {
        try {
            ElasticsearchClient client = new ElasticsearchClient(protocol, host, port, username, password, acceptAllCerts);
            BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec());
            String response = client.performRequest(method, endpoint, body);
            container.addRowToTable((DataRow)new DefaultRow(new RowKey("Row0"), new DataCell[]{JSONCellFactory.create((String)response, (boolean)false)}));
            container.close();
            return new BufferedDataTable[]{container.getTable()};
        }
        catch (Exception e) {
            LOGGER.errorWithFormat("Error while executing request: %s", new Object[]{e.getMessage()});
            throw e;
        }
    }

    private DataTableSpec createDataTableSpec() {
        return new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator("response", JSONCell.TYPE).createSpec()});
    }
}

