/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.console;

import java.util.Arrays;
import java.util.Optional;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es7.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es7.node.connect.ConnectorPanel;
import me.danielesser.knime.elasticsearch.es7.node.console.ConsoleSettings;
import me.danielesser.knime.elasticsearch.es7.port.Connection;
import me.danielesser.knime.elasticsearch.es7.util.PortHelper;
import me.danielesser.knime.elasticsearch.view.CustomDefaultNodeSettingsPane;
import me.danielesser.knime.elasticsearch.view.DialogComponentRSyntaxTextArea;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.port.PortObjectSpec;

public class ConsoleNodeDialog
extends CustomDefaultNodeSettingsPane {
    private ConsoleSettings settings = new ConsoleSettings();
    private JPanel connectionPanel = ConnectorPanel.add(this, this.settings, () -> this.getElasticsearchClient());
    private Optional<Connection> connectionOptional;

    protected ConsoleNodeDialog() {
        this.createGroup("Console Request");
        this.setHorizontalPlacement(true);
        this.addDialogComponent((DialogComponent)new DialogComponentStringSelection(this.settings.getMethod(), "Method", Arrays.asList("GET", "POST", "PUT", "DELETE"), false));
        this.addDialogComponent((DialogComponent)new DialogComponentString(this.settings.getEndpoint(), "Endpoint", false, 30));
        this.setHorizontalPlacement(false);
        this.addDialogComponent((DialogComponent)new DialogComponentRSyntaxTextArea(this.settings.getBody(), "Request Body"));
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.connectionOptional = PortHelper.getConnection(specs);
        this.connectionPanel.setVisible(!this.connectionOptional.isPresent());
    }

    private ElasticsearchClient getElasticsearchClient() {
        Connection connection = this.connectionOptional.orElse(new Connection.Builder(this.settings).build());
        return new ElasticsearchClient(connection, this.getCredentialsProvider());
    }
}

