/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.index;

import java.util.function.Supplier;
import javax.swing.JFrame;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es7.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es7.node.index.SelectIndexDialog;
import me.danielesser.knime.elasticsearch.view.CustomDefaultNodeSettingsPane;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class SearchIndexPanel {
    private SearchIndexPanel() {
    }

    public static JPanel add(CustomDefaultNodeSettingsPane pane, SettingsModelString model, Supplier<ElasticsearchClient> clientSupplier) {
        return SearchIndexPanel.add(pane, model, clientSupplier, null);
    }

    public static JPanel add(CustomDefaultNodeSettingsPane pane, SettingsModelString model, Supplier<ElasticsearchClient> clientSupplier, DialogComponent additionalComponent) {
        JPanel panel = pane.createGroup("Index");
        pane.setHorizontalPlacement(true);
        pane.addDialogComponent((DialogComponent)new DialogComponentString(model, "Index", false, 30));
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        SelectIndexDialog selectDialog = new SelectIndexDialog(frame, "Fetch Indices from Elasticsearch", clientSupplier);
        selectDialog.addConfirmListener(event -> {
            String text = selectDialog.getValue();
            model.setStringValue(text);
        });
        DialogComponentButton selectButton = new DialogComponentButton("Select an index\u2026");
        pane.addDialogComponent((DialogComponent)selectButton);
        selectButton.addActionListener(event -> {
            if (!selectDialog.isVisible()) {
                selectDialog.setVisible(true);
            }
        });
        pane.setHorizontalPlacement(false);
        if (additionalComponent != null) {
            pane.addDialogComponent(additionalComponent);
        }
        return panel;
    }
}

