/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.query;

import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

public class SearchQuerySettings
extends AbstractSettings {
    private static final String FROM_CFG_KEY = "from";
    private static final String SIZE_CFG_KEY = "size";
    private static final String QUERY_CFG_KEY = "query";
    private static final int FROM_CFG_DEFAULT = 0;
    private static final int SIZE_CFG_DEFAULT = 10;
    private static final String QUERY_CFG_DEFAULT = "{\n  \"match_all\": {}\n}";
    private final SettingsModelIntegerBounded from = new SettingsModelIntegerBounded("from", 0, 0, Integer.MAX_VALUE);
    private final SettingsModelIntegerBounded size = new SettingsModelIntegerBounded("size", 10, 0, Integer.MAX_VALUE);
    private final SettingsModelString query = new SettingsModelString("query", "{\n  \"match_all\": {}\n}");

    public SearchQuerySettings() {
        this.addSettingsModel((SettingsModel)this.from);
        this.addSettingsModel((SettingsModel)this.size);
        this.addSettingsModel((SettingsModel)this.query);
    }

    public SettingsModelInteger getFrom() {
        return this.from;
    }

    public SettingsModelInteger getSize() {
        return this.size;
    }

    public SettingsModelString getQuery() {
        return this.query;
    }

    public void validate(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        if (StringUtils.nullOrEmpty((String)this.getQuery().getStringValue().trim()) || !StringUtils.validJson((String)this.getQuery().getStringValue())) {
            throw new InvalidSettingsException("No query given or query invalid");
        }
    }
}

