/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.util;

import org.eclipse.swt.widgets.Display;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.defaultnodesettings.SettingsModel;

public final class KnimeHelper {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(KnimeHelper.class);

    private KnimeHelper() {
    }

    public static void loadSettingsFrom(NodeSettingsRO settings, SettingsModel model) {
        try {
            model.loadSettingsFrom(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            LOGGER.debug((Object)"Ignoring setting for backwards compatibility.");
        }
    }

    public static void validateSettings(NodeSettingsRO settings, SettingsModel model) {
        try {
            model.validateSettings(settings);
        }
        catch (InvalidSettingsException invalidSettingsException) {
            LOGGER.debug((Object)"Ignoring setting for backwards compatibility.");
        }
    }

    public static void runInDisplayThread(final Runnable function) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                function.run();
            }
        });
    }
}

