/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.port.PortObjectSpec;

public class DialogComponentButtonLabel
extends DialogComponent {
    private JButton m_button;
    private JLabel m_label;

    public DialogComponentButtonLabel(String buttonText, String labelText) {
        super((SettingsModel)new DialogComponent.EmptySettingsModel());
        this.getComponentPanel().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        this.m_button = new JButton(buttonText);
        this.m_label = new JLabel(labelText);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        panel.add((Component)this.m_button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 100.0;
        gbc.insets = new Insets(0, 5, 0, 5);
        panel.add((Component)this.m_label, gbc);
        this.getComponentPanel().add((Component)panel, "Center");
    }

    public void addActionListener(ActionListener listener) {
        this.m_button.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.m_button.removeActionListener(listener);
    }

    public void setButtonText(String text) {
        this.m_button.setText(text);
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
    }

    protected void setEnabledComponents(boolean enabled) {
        this.m_button.setEnabled(enabled);
        this.m_label.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.m_button.setToolTipText(text);
        this.m_label.setToolTipText(text);
    }

    protected void updateComponent() {
    }

    protected void validateSettingsBeforeSave() throws InvalidSettingsException {
    }
}

