/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.view;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.StringIconListCellRenderer;

public class DialogComponentComboBox
extends DialogComponent {
    private final JComboBox<String> m_combobox;
    private final JLabel m_label;

    public DialogComponentComboBox(String label, int width, String ... list) {
        this(label, width, Arrays.asList(list));
    }

    public DialogComponentComboBox(String label, int width, Collection<String> list) {
        super((SettingsModel)new DialogComponent.EmptySettingsModel());
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("Selection list of options shouldn't be null or empty");
        }
        this.m_label = new JLabel(label);
        this.getComponentPanel().add(this.m_label);
        this.m_combobox = new JComboBox();
        this.m_combobox.setRenderer((ListCellRenderer<String>)new StringIconListCellRenderer());
        this.m_combobox.setPreferredSize(new Dimension(width, 25));
        list.forEach(this.m_combobox::addItem);
        this.getComponentPanel().add(this.m_combobox);
    }

    protected void updateComponent() {
    }

    protected void validateSettingsBeforeSave() throws InvalidSettingsException {
    }

    protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
    }

    protected void setEnabledComponents(boolean enabled) {
        this.m_combobox.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.m_label.setToolTipText(text);
        this.m_combobox.setToolTipText(text);
    }

    public String getSelection() {
        return (String)this.m_combobox.getSelectedItem();
    }

    public void replaceListItems(Collection<String> items) {
        if (items == null || items.size() < 1) {
            throw new NullPointerException("The container with the new items can't be null or empty.");
        }
        this.m_combobox.removeAllItems();
        items.forEach(this.m_combobox::addItem);
        this.m_combobox.setSize(this.m_combobox.getPreferredSize());
        this.getComponentPanel().validate();
    }
}

