/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.danielesser.knime.elasticsearch.es7.port.Connection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.knime.core.node.NodeLogger;

public class ElasticsearchClient
implements AutoCloseable {
    public static final int ELASTICSEARCH_MAX_RESULT_WINDOW = 10000;
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ElasticsearchClient.class);
    private RestHighLevelClient client;

    public ElasticsearchClient(String protocol, String host, int port) {
        this(protocol, host, port, null, null, false);
    }

    public ElasticsearchClient(String protocol, String host, int port, boolean acceptAllCerts) {
        this(protocol, host, port, null, null, acceptAllCerts);
    }

    public ElasticsearchClient(Connection connection, org.knime.core.node.workflow.CredentialsProvider cp) {
        this(connection.getProtocol(), connection.getHost(), connection.getPort(), connection.getUsername(cp), connection.getPassword(cp), connection.getAcceptAllCerts());
    }

    public ElasticsearchClient(String protocol, String host, int port, String username, String password) {
        this.client = this.createClient(protocol, host, port, username, password, false);
    }

    public ElasticsearchClient(String protocol, String host, int port, String username, String password, boolean acceptAllCerts) {
        this.client = this.createClient(protocol, host, port, username, password, acceptAllCerts);
    }

    public RestHighLevelClient getRestHighLevelClient() {
        return this.client;
    }

    public RestClient getRestClient() {
        return this.client.getLowLevelClient();
    }

    @Override
    public void close() throws Exception {
        LOGGER.debug((Object)"Close Elasticsearch client");
        this.client.close();
    }

    public String performRequest(String method, String endpoint) throws IOException {
        return this.performRequest(method, endpoint, null);
    }

    public String performRequest(String method, String endpoint, String body) throws IOException {
        LOGGER.debugWithFormat("Perform API request: method=%s, endpoint=%s, body=%s", new Object[]{method, endpoint, body});
        Object extendedEndpoint = endpoint.startsWith("/") ? endpoint : "/" + endpoint;
        Request request = new Request(method, (String)extendedEndpoint);
        if (body != null) {
            request.setJsonEntity(body);
        }
        return EntityUtils.toString((HttpEntity)this.client.getLowLevelClient().performRequest(request).getEntity());
    }

    public String getVersion() {
        try {
            MainResponse response = this.client.info(RequestOptions.DEFAULT);
            return response.getVersion().getNumber();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ClusterHealthResponse getClusterHealth() throws IOException {
        ClusterHealthRequest request = new ClusterHealthRequest();
        request.timeout(TimeValue.timeValueSeconds((long)5L));
        return this.client.cluster().health(request, RequestOptions.DEFAULT);
    }

    public SearchResponse performSearchRequest(String index, String route, String query, int from, int size) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)query));
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(size);
        searchRequest.source(searchSourceBuilder);
        if (index != null && !index.isEmpty()) {
            searchRequest.indices(new String[]{index});
        }
        if (route != null && !route.isEmpty()) {
            searchRequest.routing(route);
        }
        return this.client.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse performScrollRequest(String index, String route, String query, int size) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)query));
        searchSourceBuilder.size(size);
        if (index != null && !index.isEmpty()) {
            searchRequest.indices(new String[]{index});
        }
        if (route != null && !route.isEmpty()) {
            searchRequest.routing(route);
        }
        searchRequest.source(searchSourceBuilder);
        searchRequest.scroll(TimeValue.timeValueMinutes((long)2L));
        return this.client.search(searchRequest, RequestOptions.DEFAULT);
    }

    public SearchResponse performScrollRequest(String scrollId) throws IOException {
        SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
        scrollRequest.scroll(TimeValue.timeValueSeconds((long)30L));
        return this.client.scroll(scrollRequest, RequestOptions.DEFAULT);
    }

    public ClearScrollResponse cancelScrollRequest(String scrollId) throws IOException {
        ClearScrollRequest request = new ClearScrollRequest();
        request.addScrollId(scrollId);
        return this.client.clearScroll(request, RequestOptions.DEFAULT);
    }

    public IndexResponse performIndexRequest(String index, String route, String id, String body) throws IOException {
        IndexRequest request = new IndexRequest(index).id(id).source(body, XContentType.JSON);
        if (route != null && !route.isEmpty()) {
            request.routing(route);
        }
        return this.client.index(request, RequestOptions.DEFAULT);
    }

    public List<String> getIndices() throws IOException {
        return this.getIndices(true);
    }

    public List<String> getIndices(boolean includeAliases) throws IOException {
        return this.client.indices().getAlias(new GetAliasesRequest(), RequestOptions.DEFAULT).getAliases().entrySet().stream().map(entry -> {
            ArrayList<String> indices = new ArrayList<String>();
            indices.add((String)entry.getKey());
            if (includeAliases) {
                indices.addAll(((Set)entry.getValue()).stream().map(e -> e.getAlias()).collect(Collectors.toList()));
            }
            return indices;
        }).flatMap(l -> l.stream()).sorted().distinct().collect(Collectors.toList());
    }

    private RestHighLevelClient createClient(String protocol, String host, int port, final String username, final String password, final boolean acceptAllCerts) {
        LOGGER.debugWithFormat("Create Elasticsearch client: protocol=%s, host=%s, port=%d, acceptAllCerts=%b", new Object[]{protocol, host, port, acceptAllCerts});
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, protocol)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                HttpAsyncClientBuilder builder = httpClientBuilder;
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username != null ? username : "", password != null ? password : ""));
                builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                if (acceptAllCerts) {
                    try {
                        builder = builder.setSSLContext(SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build());
                    }
                    catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                        LOGGER.warn((Object)"Setting SSLContext failed. \"Accept all certificates\" option could not be enabled.");
                    }
                }
                return builder;
            }
        }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(10000).setSocketTimeout(30000);
            }
        }));
    }
}

