/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.index;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es7.ElasticsearchClient;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.defaultnodesettings.DialogComponentButton;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class SelectIndexDialog
extends JDialog {
    private static final long serialVersionUID = -5643801627757597736L;
    private static final NodeLogger LOGGER = NodeLogger.getLogger(SelectIndexDialog.class);
    private SettingsModelString suggestionModel = new SettingsModelString("suggestion", "");
    private JButton selectButton = new JButton("Select");

    public SelectIndexDialog(JFrame frame, String title, Supplier<ElasticsearchClient> clientSupplier) {
        super(frame, title, true);
        JPanel panel = new JPanel(new GridBagLayout());
        DialogComponentStringSelection suggestionList = new DialogComponentStringSelection(this.suggestionModel, "Indices", new String[]{""});
        suggestionList.setSizeComponents(300, 25);
        GridBagConstraints gbcSuggestion = new GridBagConstraints();
        gbcSuggestion.fill = 2;
        gbcSuggestion.gridx = 0;
        gbcSuggestion.gridy = 0;
        panel.add((Component)suggestionList.getComponentPanel(), gbcSuggestion);
        DialogComponentButton fetchButton = new DialogComponentButton("Fetch");
        GridBagConstraints gbcFetch = new GridBagConstraints();
        gbcFetch.fill = 2;
        gbcFetch.gridx = 1;
        gbcFetch.gridy = 0;
        panel.add((Component)fetchButton.getComponentPanel(), gbcFetch);
        DialogComponentLabel fetchStatus = new DialogComponentLabel("Status: Click \"Fetch\" to query indices from Elasticsearch.");
        GridBagConstraints gbcStatus = new GridBagConstraints();
        gbcStatus.fill = 2;
        gbcStatus.gridx = 0;
        gbcStatus.gridy = 1;
        gbcStatus.gridwidth = 3;
        panel.add((Component)fetchStatus.getComponentPanel(), gbcStatus);
        JPanel panelButtons = new JPanel(new GridBagLayout());
        GridBagConstraints gbcButtons = new GridBagConstraints();
        gbcButtons.fill = 2;
        gbcButtons.gridx = 0;
        gbcButtons.gridy = 2;
        gbcButtons.gridwidth = 3;
        panel.add((Component)panelButtons, gbcButtons);
        GridBagConstraints gbcSelect = new GridBagConstraints();
        gbcSelect.fill = 2;
        gbcSelect.gridx = 0;
        gbcSelect.gridy = 0;
        panelButtons.add((Component)this.selectButton, gbcSelect);
        this.selectButton.addActionListener(event -> this.setVisible(false));
        JButton cancelButton = new JButton("Cancel");
        GridBagConstraints gbcCancel = new GridBagConstraints();
        gbcCancel.fill = 2;
        gbcCancel.gridx = 1;
        gbcCancel.gridy = 0;
        panelButtons.add((Component)cancelButton, gbcCancel);
        cancelButton.addActionListener(event -> this.setVisible(false));
        fetchButton.addActionListener(event -> {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ElasticsearchClient client = (ElasticsearchClient)clientSupplier.get();){
                    List<String> indices = client.getIndices();
                    if (indices.size() == 0) {
                        indices.add(0, "");
                    }
                    fetchStatus.setText("<html>Status: <font color='green'>Available indices updated!</font></html>");
                    suggestionList.replaceListItems(indices, null);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.warnWithFormat("Connection failed: %s", new Object[]{e.getMessage()});
                fetchStatus.setText("<html>Status: <font color='red'>Error fetching available indices! Please check your connection.</font></html>");
            }
        });
        this.add(panel);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(frame);
    }

    public String getValue() {
        return this.suggestionModel.getStringValue();
    }

    public void addConfirmListener(ActionListener listener) {
        this.selectButton.addActionListener(listener);
    }
}

