/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.read;

import java.util.Optional;
import me.danielesser.knime.elasticsearch.es7.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es7.node.read.ReaderSettings;
import me.danielesser.knime.elasticsearch.es7.port.Connection;
import me.danielesser.knime.elasticsearch.es7.port.ConnectionPortObject;
import me.danielesser.knime.elasticsearch.es7.port.Search;
import me.danielesser.knime.elasticsearch.es7.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractNodeModel;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.LicenseChecker;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class ReaderNodeModel
extends AbstractNodeModel<ReaderSettings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ReaderNodeModel.class);
    private static final String ES_FIELD_INDEX = "_index";
    private static final String ES_FIELD_ID = "_id";
    private static final String ES_FIELD_SCORE = "_score";
    private static final String ES_FIELD_SOURCE = "_source";

    public ReaderNodeModel() {
        super(new PortType[]{ConnectionPortObject.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE}, (AbstractSettings)new ReaderSettings());
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        if (!PortHelper.getConnection(inSpecs).isPresent() && !PortHelper.getSearch(inSpecs).isPresent()) {
            ((ReaderSettings)this.getSettings()).validate(inSpecs);
        }
        return new DataTableSpec[]{this.createDataTableSpec()};
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        LicenseChecker.getLicense();
        Optional<Search> searchOptional = PortHelper.getSearch(inData);
        if (searchOptional.isPresent()) {
            Search search = searchOptional.get();
            String index = search.getIndex() != null ? search.getIndex() : ((ReaderSettings)this.getSettings()).getIndex().getStringValue();
            String route = search.getRoute() != null ? search.getRoute() : ((ReaderSettings)this.getSettings()).getRoute().getStringValue();
            int from = search.getFrom() != null ? search.getFrom().intValue() : ((ReaderSettings)this.getSettings()).getFrom().getIntValue();
            int size = search.getSize() != null ? search.getSize().intValue() : ((ReaderSettings)this.getSettings()).getSize().getIntValue();
            String query = search.getQuery() != null ? search.getQuery() : ((ReaderSettings)this.getSettings()).getQuery().getStringValue();
            return this.query(exec, search.getProtocol(), search.getHost(), search.getPort(), search.getUsername(this.getCredentialsProvider()), search.getPassword(this.getCredentialsProvider()), search.getAcceptAllCerts(), index, route, from, size, query);
        }
        Optional<Connection> connectionOptional = PortHelper.getConnection(inData);
        if (connectionOptional.isPresent()) {
            Connection connection = connectionOptional.get();
            return this.query(exec, connection.getProtocol(), connection.getHost(), connection.getPort(), connection.getUsername(this.getCredentialsProvider()), connection.getPassword(this.getCredentialsProvider()), connection.getAcceptAllCerts(), ((ReaderSettings)this.getSettings()).getIndex().getStringValue(), ((ReaderSettings)this.getSettings()).getRoute().getStringValue(), ((ReaderSettings)this.getSettings()).getFrom().getIntValue(), ((ReaderSettings)this.getSettings()).getSize().getIntValue(), ((ReaderSettings)this.getSettings()).getQuery().getStringValue());
        }
        return this.query(exec, ((ReaderSettings)this.getSettings()).getProtocol().getStringValue(), ((ReaderSettings)this.getSettings()).getHost().getStringValue(), ((ReaderSettings)this.getSettings()).getPort().getIntValue(), ((ReaderSettings)this.getSettings()).getAuth().getUserName(this.getCredentialsProvider()), ((ReaderSettings)this.getSettings()).getAuth().getPassword(this.getCredentialsProvider()), ((ReaderSettings)this.getSettings()).getAcceptAllCerts().getBooleanValue(), ((ReaderSettings)this.getSettings()).getIndex().getStringValue(), ((ReaderSettings)this.getSettings()).getRoute().getStringValue(), ((ReaderSettings)this.getSettings()).getFrom().getIntValue(), ((ReaderSettings)this.getSettings()).getSize().getIntValue(), ((ReaderSettings)this.getSettings()).getQuery().getStringValue());
    }

    private BufferedDataTable[] query(ExecutionContext exec, String protocol, String host, int port, String username, String password, boolean acceptAllCerts, String index, String route, int from, int size, String query) throws Exception {
        exec.setProgress("Preparing query operation\u2026");
        try {
            Throwable throwable = null;
            Object var14_17 = null;
            try (ElasticsearchClient client = new ElasticsearchClient(protocol, host, port, username, password, acceptAllCerts);){
                int updatedSize = size == 0 ? Integer.MAX_VALUE : size;
                String updatedQuery = StringUtils.stripOuterQueryFromJSON((String)query);
                BufferedDataContainer container = from + updatedSize <= 10000 ? this.singleQuery(exec, client, index, route, from, updatedSize, updatedQuery) : this.scrollQuery(exec, client, index, route, from, updatedSize, updatedQuery);
                container.close();
                return new BufferedDataTable[]{container.getTable()};
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ElasticsearchException e) {
            LOGGER.errorWithFormat("Error while performing query: %s", new Object[]{e.getDetailedMessage()});
            throw e;
        }
        catch (Exception e) {
            LOGGER.errorWithFormat("Error while performing query: %s", new Object[]{e.getMessage()});
            throw e;
        }
    }

    private BufferedDataContainer singleQuery(ExecutionContext exec, ElasticsearchClient client, String index, String route, int from, int size, String query) throws Exception {
        SearchHit[] searchHits;
        int rowNumber = 0;
        BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec());
        SearchResponse response = client.performSearchRequest(index, route, query, from, size);
        SearchHit[] searchHitArray = searchHits = response.getHits().getHits();
        int n = searchHits.length;
        int n2 = 0;
        while (n2 < n) {
            SearchHit hit = searchHitArray[n2];
            container.addRowToTable(this.createRow(hit, rowNumber));
            exec.checkCanceled();
            exec.setProgress((double)rowNumber++ / (double)size, "Reading search result #" + rowNumber);
            ++n2;
        }
        this.setFlowVariables(response);
        return container;
    }

    private BufferedDataContainer scrollQuery(ExecutionContext exec, ElasticsearchClient client, String index, String route, int from, int size, String query) throws Exception {
        int rowNumber = 0;
        int totalTook = 0;
        int count = 0;
        int totalSize = from + size;
        int batchSize = (int)Math.ceil((double)totalSize / (double)((int)Math.ceil((double)totalSize / 10000.0)));
        BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec());
        SearchResponse response = client.performScrollRequest(index, route, query, batchSize);
        String scrollId = response.getScrollId();
        SearchHit[] searchHits = response.getHits().getHits();
        totalTook = (int)((long)totalTook + response.getTook().millis());
        while (searchHits != null && searchHits.length > 0 && rowNumber < size) {
            SearchHit[] searchHitArray = response.getHits().getHits();
            int n = searchHitArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchHit hit = searchHitArray[n2];
                if (count >= from) {
                    container.addRowToTable(this.createRow(hit, rowNumber));
                    exec.setProgress((double)rowNumber++ / (double)size, "Reading search result #" + rowNumber);
                }
                exec.checkCanceled();
                ++count;
                ++n2;
            }
            response = client.performScrollRequest(scrollId);
            scrollId = response.getScrollId();
            searchHits = response.getHits().getHits();
        }
        client.cancelScrollRequest(scrollId);
        this.setFlowVariables(response);
        this.setFlowVariable("es_took", totalTook);
        return container;
    }

    private DataTableSpec createDataTableSpec() {
        return new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator(ES_FIELD_INDEX, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_ID, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_SCORE, DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_SOURCE, JSONCell.TYPE).createSpec()});
    }

    private DataRow createRow(SearchHit hit, int rowNumber) throws Exception {
        return new DefaultRow(new RowKey("Row" + rowNumber), new DataCell[]{new StringCell(hit.getIndex()), new StringCell(hit.getId()), new DoubleCell((double)hit.getScore()), JSONCellFactory.create((String)hit.getSourceAsString(), (boolean)false)});
    }

    private void setFlowVariables(SearchResponse response) {
        this.setFlowVariable("es_took", response.getTook().getStringRep());
        this.setFlowVariable("es_timed_out", Boolean.toString(response.isTimedOut()));
        this.setFlowVariable("es_hits_total_value", (int)response.getHits().getTotalHits().value);
        this.setFlowVariable("es_hits_max_score", (int)response.getHits().getMaxScore());
        this.setFlowVariable("es_shards_total", response.getTotalShards());
        this.setFlowVariable("es_shards_successful", response.getSuccessfulShards());
        this.setFlowVariable("es_shards_skipped", response.getSkippedShards());
        this.setFlowVariable("es_shards_failed", response.getFailedShards());
    }
}

