/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.read;

import java.util.Optional;
import me.danielesser.knime.elasticsearch.es7.node.IConnectionSettings;
import me.danielesser.knime.elasticsearch.es7.port.Search;
import me.danielesser.knime.elasticsearch.es7.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelAuthentication;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

public class ReaderSettings
extends AbstractSettings
implements IConnectionSettings {
    private static final String AUTH_CFG_KEY = "auth";
    private static final String PROTOCOL_CFG_KEY = "protocol";
    private static final String HOST_CFG_KEY = "host";
    private static final String PORT_CFG_KEY = "port";
    private static final String ACCEPT_ALL_CERTS_CFG_KEY = "acceptAllCertificates";
    private static final String INDEX_CFG_KEY = "index";
    private static final String ROUTE_CFG_KEY = "route";
    private static final String FROM_CFG_KEY = "from";
    private static final String SIZE_CFG_KEY = "size";
    private static final String QUERY_CFG_KEY = "query";
    private static final SettingsModelAuthentication.AuthenticationType AUTH_CFG_DEFAULT = SettingsModelAuthentication.AuthenticationType.NONE;
    private static final String PROTOCOL_CFG_DEFAULT = "http";
    private static final String HOST_CFG_DEFAULT = "localhost";
    private static final int PORT_CFG_DEFAULT = 9200;
    private static final boolean ACCEPT_ALL_CERTS_CFG_DEFAULT = false;
    private static final String INDEX_CFG_DEFAULT = "";
    private static final String ROUTE_CFG_DEFAULT = "";
    private static final int FROM_CFG_DEFAULT = 0;
    private static final int SIZE_CFG_DEFAULT = 10;
    private static final String QUERY_CFG_DEFAULT = "{\n  \"match_all\": {}\n}";
    private final SettingsModelAuthentication auth = new SettingsModelAuthentication("auth", AUTH_CFG_DEFAULT);
    private final SettingsModelString protocol = new SettingsModelString("protocol", "http");
    private final SettingsModelString host = new SettingsModelString("host", "localhost");
    private final SettingsModelInteger port = new SettingsModelInteger("port", 9200);
    private final SettingsModelBoolean acceptAllCerts = new SettingsModelBoolean("acceptAllCertificates", false);
    private final SettingsModelString index = new SettingsModelString("index", "");
    private final SettingsModelString route = new SettingsModelString("route", "");
    private final SettingsModelIntegerBounded from = new SettingsModelIntegerBounded("from", 0, 0, Integer.MAX_VALUE);
    private final SettingsModelIntegerBounded size = new SettingsModelIntegerBounded("size", 10, 0, Integer.MAX_VALUE);
    private final SettingsModelString query = new SettingsModelString("query", "{\n  \"match_all\": {}\n}");

    ReaderSettings() {
        this.addSettingsModel((SettingsModel)this.auth);
        this.addSettingsModel((SettingsModel)this.protocol);
        this.addSettingsModel((SettingsModel)this.host);
        this.addSettingsModel((SettingsModel)this.port);
        this.addSettingsModel((SettingsModel)this.acceptAllCerts);
        this.addSettingsModel((SettingsModel)this.index);
        this.addSettingsModel((SettingsModel)this.route);
        this.addSettingsModel((SettingsModel)this.from);
        this.addSettingsModel((SettingsModel)this.size);
        this.addSettingsModel((SettingsModel)this.query);
    }

    @Override
    public SettingsModelAuthentication getAuth() {
        return this.auth;
    }

    @Override
    public SettingsModelString getProtocol() {
        return this.protocol;
    }

    @Override
    public SettingsModelString getHost() {
        return this.host;
    }

    @Override
    public SettingsModelInteger getPort() {
        return this.port;
    }

    @Override
    public SettingsModelBoolean getAcceptAllCerts() {
        return this.acceptAllCerts;
    }

    public SettingsModelString getIndex() {
        return this.index;
    }

    public SettingsModelString getRoute() {
        return this.route;
    }

    public SettingsModelInteger getFrom() {
        return this.from;
    }

    public SettingsModelInteger getSize() {
        return this.size;
    }

    public SettingsModelString getQuery() {
        return this.query;
    }

    public void validate(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        Optional<Search> searchOptional;
        String query;
        if (!PortHelper.getConnection(inSpecs).isPresent()) {
            if (StringUtils.nullOrEmpty((String)this.getProtocol().getStringValue().trim())) {
                throw new InvalidSettingsException("No protocol given");
            }
            if (StringUtils.nullOrEmpty((String)this.getHost().getStringValue().trim())) {
                throw new InvalidSettingsException("No host given");
            }
        }
        String string = query = (searchOptional = PortHelper.getSearch(inSpecs)).isPresent() && searchOptional.get().getQuery() != null ? searchOptional.get().getQuery() : this.getQuery().getStringValue();
        if (StringUtils.nullOrEmpty((String)query.trim()) || !StringUtils.validJson((String)query)) {
            throw new InvalidSettingsException("No query given or query invalid");
        }
    }
}

