/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.write;

import me.danielesser.knime.elasticsearch.es7.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es7.node.IConnectionSettings;
import me.danielesser.knime.elasticsearch.es7.node.write.WriterSettings;
import me.danielesser.knime.elasticsearch.es7.port.Connection;
import me.danielesser.knime.elasticsearch.es7.port.ConnectionPortObject;
import me.danielesser.knime.elasticsearch.es7.port.Search;
import me.danielesser.knime.elasticsearch.es7.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractNodeModel;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.LicenseChecker;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.index.IndexResponse;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.append.AppendedColumnRow;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONValue;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class WriterNodeModel
extends AbstractNodeModel<WriterSettings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(WriterNodeModel.class);
    private static final String ES_FIELD_INDEX = "_index";
    private static final String ES_FIELD_ID = "_id";
    private static final String ES_FIELD_VERSION = "_version";
    private static final String ES_FIELD_RESULT = "_result";

    protected WriterNodeModel() {
        super(new PortType[]{ConnectionPortObject.TYPE_OPTIONAL, BufferedDataTable.TYPE}, new PortType[]{BufferedDataTable.TYPE}, (AbstractSettings)new WriterSettings());
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        LicenseChecker.getLicense();
        exec.setProgress("Preparing write operation\u2026");
        BufferedDataTable inRows = (BufferedDataTable)inData[1];
        DataTableSpec inTableSpec = inRows.getSpec();
        String idColumn = ((WriterSettings)this.getSettings()).getIdColumn().getStringValue();
        int idIdx = inTableSpec.findColumnIndex(idColumn);
        String indexColumn = ((WriterSettings)this.getSettings()).getIndexColumn().getStringValue();
        int indexIdx = inTableSpec.findColumnIndex(indexColumn);
        String documentColumn = ((WriterSettings)this.getSettings()).getDocumentColumn().getStringValue();
        int documentIdx = inTableSpec.findColumnIndex(documentColumn);
        Search search = PortHelper.getSearch(inData).orElse(new Search.Builder().build());
        String defaultIndex = search.getIndex() != null ? search.getIndex() : ((WriterSettings)this.getSettings()).getIndex().getStringValue();
        String route = search.getRoute() != null ? search.getRoute() : ((WriterSettings)this.getSettings()).getRoute().getStringValue();
        Connection connection = PortHelper.getConnection(inData).orElse(new Connection.Builder((IConnectionSettings)this.getSettings()).build());
        long countSkipped = 0L;
        BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec(inRows.getSpec()));
        try {
            Throwable throwable = null;
            Object var19_20 = null;
            try (ElasticsearchClient client = connection.createClient(this.getCredentialsProvider());){
                long numInRows = inRows.size();
                long currentRow = 0L;
                for (DataRow inRow : inRows) {
                    DataCell documentCell = inRow.getCell(documentIdx);
                    if (documentCell.isMissing()) {
                        LOGGER.warnWithFormat("Skipping %s: Row does not provide valid content.", new Object[]{inRow.getKey()});
                        container.addRowToTable(this.createRow(inRow));
                        ++countSkipped;
                        continue;
                    }
                    String id = null;
                    if (idIdx > -1) {
                        DataCell idCell = inRow.getCell(idIdx);
                        if (idCell.isMissing()) {
                            LOGGER.warnWithFormat("Skipping %s: Row does not provide an id.", new Object[]{inRow.getKey()});
                            container.addRowToTable(this.createRow(inRow));
                            ++countSkipped;
                            continue;
                        }
                        id = ((StringCell)idCell).getStringValue();
                    }
                    String index = defaultIndex;
                    if (indexIdx > -1) {
                        DataCell indexCell = inRow.getCell(indexIdx);
                        if (indexCell.isMissing()) {
                            if (StringUtils.nullOrEmpty((String)index.trim())) {
                                LOGGER.warnWithFormat("Skipping %s: Row does not provide an index and no default index set.", new Object[]{inRow.getKey()});
                                container.addRowToTable(this.createRow(inRow));
                                ++countSkipped;
                                continue;
                            }
                            LOGGER.infoWithFormat("Processing %s: Row does not provide an index. Using default index %s instead.", new Object[]{inRow.getKey(), index});
                        } else {
                            index = ((StringCell)indexCell).getStringValue();
                        }
                    }
                    try {
                        String document = ((JSONValue)documentCell).getJsonValue().toString();
                        IndexResponse response = client.performIndexRequest(index, route, id, document);
                        container.addRowToTable(this.createRow(inRow, response));
                    }
                    catch (ElasticsearchException e) {
                        LOGGER.errorWithFormat("Skipping %s: Received an error: %s", new Object[]{inRow.getKey(), e.getDetailedMessage()});
                        this.passOrThrow((Exception)((Object)e));
                        container.addRowToTable(this.createRow(inRow));
                        ++countSkipped;
                    }
                    catch (Exception e) {
                        LOGGER.errorWithFormat("Skipping %s: Received an error: %s", new Object[]{inRow.getKey(), e.getMessage()});
                        this.passOrThrow(e);
                        container.addRowToTable(this.createRow(inRow));
                        ++countSkipped;
                    }
                    exec.checkCanceled();
                    exec.setProgress((double)currentRow++ / (double)numInRows, "Writing document #" + currentRow);
                }
                if (countSkipped > 0L) {
                    this.setWarningMessage(countSkipped + " documents could not be written. Please check the logs.");
                }
                container.close();
                return new BufferedDataTable[]{container.getTable()};
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.errorWithFormat("Error writing documents: %s", new Object[]{e.getMessage()});
            throw e;
        }
    }

    private void passOrThrow(Exception e) throws Exception {
        if (((WriterSettings)this.getSettings()).getFailOnError().getBooleanValue()) {
            LOGGER.error((Object)"Aborting execution: Fail on error enabled.");
            throw e;
        }
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        ((WriterSettings)this.getSettings()).validate(inSpecs);
        return new PortObjectSpec[]{this.createDataTableSpec((DataTableSpec)inSpecs[1])};
    }

    private DataTableSpec createDataTableSpec(DataTableSpec inSpec) {
        if (!((WriterSettings)this.getSettings()).getAppendResultColumns().getBooleanValue()) {
            return inSpec;
        }
        DataTableSpec resultSpec = new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator(ES_FIELD_INDEX, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_ID, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_VERSION, LongCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_RESULT, StringCell.TYPE).createSpec()});
        DataColumnSpec[] resultCols = new DataColumnSpec[resultSpec.getNumColumns()];
        int i = 0;
        while (i < resultSpec.getNumColumns()) {
            DataColumnSpec col = resultSpec.getColumnSpec(i);
            Object name = inSpec.containsName(col.getName()) ? col.getName() + "_dup" : col.getName();
            DataColumnSpecCreator creator = new DataColumnSpecCreator(col);
            creator.setName((String)name);
            resultCols[i] = creator.createSpec();
            ++i;
        }
        return new DataTableSpec(inSpec, new DataTableSpec(resultCols));
    }

    private DataRow createRow(DataRow row) {
        if (!((WriterSettings)this.getSettings()).getAppendResultColumns().getBooleanValue()) {
            return row;
        }
        return new AppendedColumnRow(row, new DataCell[]{DataType.getMissingCell(), DataType.getMissingCell(), DataType.getMissingCell(), new StringCell("skipped")});
    }

    private DataRow createRow(DataRow row, IndexResponse response) {
        if (!((WriterSettings)this.getSettings()).getAppendResultColumns().getBooleanValue()) {
            return row;
        }
        return new AppendedColumnRow(row, new DataCell[]{new StringCell(response.getIndex()), new StringCell(response.getId()), new LongCell(response.getVersion()), new StringCell(response.getResult().getLowercase())});
    }
}

