/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.node.write;

import java.util.Optional;
import me.danielesser.knime.elasticsearch.es7.node.IConnectionSettings;
import me.danielesser.knime.elasticsearch.es7.port.Search;
import me.danielesser.knime.elasticsearch.es7.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelAuthentication;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

public class WriterSettings
extends AbstractSettings
implements IConnectionSettings {
    private static final String AUTH_CFG_KEY = "auth";
    private static final String PROTOCOL_CFG_KEY = "protocol";
    private static final String HOST_CFG_KEY = "host";
    private static final String PORT_CFG_KEY = "port";
    private static final String ACCEPT_ALL_CERTS_CFG_KEY = "acceptAllCertificates";
    private static final String INDEX_CFG_KEY = "index";
    private static final String ROUTE_CFG_KEY = "route";
    private static final String ID_COLUMN_CFG_KEY = "idColumn";
    private static final String INDEX_COLUMN_CFG_KEY = "indexColumn";
    private static final String DOCUMENT_COLUMN_CFG_KEY = "documentColumn";
    private static final String APPEND_RESULT_COLUMNS_CFG_KEY = "appendResultColumns";
    private static final String FAIL_ON_ERROR_CFG_KEY = "failOnError";
    private static final SettingsModelAuthentication.AuthenticationType AUTH_CFG_DEFAULT = SettingsModelAuthentication.AuthenticationType.NONE;
    private static final String PROTOCOL_CFG_DEFAULT = "http";
    private static final String HOST_CFG_DEFAULT = "localhost";
    private static final int PORT_CFG_DEFAULT = 9200;
    private static final boolean ACCEPT_ALL_CERTS_CFG_DEFAULT = false;
    private static final String INDEX_CFG_DEFAULT = "";
    private static final String ROUTE_CFG_DEFAULT = "";
    private static final String INDEX_COLUMN_CFG_DEFAULT = "";
    private static final String ID_COLUMN_CFG_DEFAULT = "";
    private static final boolean APPEND_RESULT_COLUMNS_CFG_DEFAULT = true;
    private static final boolean FAIL_ON_ERROR_CFG_DEFAULT = true;
    private final SettingsModelAuthentication auth = new SettingsModelAuthentication("auth", AUTH_CFG_DEFAULT);
    private final SettingsModelString protocol = new SettingsModelString("protocol", "http");
    private final SettingsModelString host = new SettingsModelString("host", "localhost");
    private final SettingsModelInteger port = new SettingsModelInteger("port", 9200);
    private final SettingsModelBoolean acceptAllCerts = new SettingsModelBoolean("acceptAllCertificates", false);
    private final SettingsModelString index = new SettingsModelString("index", "");
    private final SettingsModelString route = new SettingsModelString("route", "");
    private final SettingsModelString idColumn = new SettingsModelString("idColumn", "");
    private final SettingsModelString indexColumn = new SettingsModelString("indexColumn", "");
    private final SettingsModelString documentColumn = new SettingsModelString("documentColumn", null);
    private final SettingsModelBoolean appendResultColumns = new SettingsModelBoolean("appendResultColumns", true);
    private final SettingsModelBoolean failOnError = new SettingsModelBoolean("failOnError", true);

    WriterSettings() {
        this.addSettingsModel((SettingsModel)this.auth);
        this.addSettingsModel((SettingsModel)this.protocol);
        this.addSettingsModel((SettingsModel)this.host);
        this.addSettingsModel((SettingsModel)this.port);
        this.addSettingsModel((SettingsModel)this.acceptAllCerts);
        this.addSettingsModel((SettingsModel)this.index);
        this.addSettingsModel((SettingsModel)this.route);
        this.addSettingsModel((SettingsModel)this.idColumn);
        this.addSettingsModel((SettingsModel)this.indexColumn);
        this.addSettingsModel((SettingsModel)this.documentColumn);
        this.addSettingsModel((SettingsModel)this.appendResultColumns);
        this.addSettingsModel((SettingsModel)this.failOnError);
    }

    @Override
    public SettingsModelAuthentication getAuth() {
        return this.auth;
    }

    @Override
    public SettingsModelString getProtocol() {
        return this.protocol;
    }

    @Override
    public SettingsModelString getHost() {
        return this.host;
    }

    @Override
    public SettingsModelInteger getPort() {
        return this.port;
    }

    @Override
    public SettingsModelBoolean getAcceptAllCerts() {
        return this.acceptAllCerts;
    }

    public SettingsModelString getIndex() {
        return this.index;
    }

    public SettingsModelString getRoute() {
        return this.route;
    }

    public SettingsModelString getIdColumn() {
        return this.idColumn;
    }

    public SettingsModelString getIndexColumn() {
        return this.indexColumn;
    }

    public SettingsModelString getDocumentColumn() {
        return this.documentColumn;
    }

    public SettingsModelBoolean getAppendResultColumns() {
        return this.appendResultColumns;
    }

    public SettingsModelBoolean getFailOnError() {
        return this.failOnError;
    }

    public void validate(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        String index;
        if (!PortHelper.getConnection(inSpecs).isPresent()) {
            if (StringUtils.nullOrEmpty((String)this.getProtocol().getStringValue().trim())) {
                throw new InvalidSettingsException("No protocol given");
            }
            if (StringUtils.nullOrEmpty((String)this.getHost().getStringValue().trim())) {
                throw new InvalidSettingsException("No host given");
            }
        }
        DataTableSpec inTableSpec = (DataTableSpec)inSpecs[1];
        Optional<Search> searchOptional = PortHelper.getSearch(inSpecs);
        String string = index = searchOptional.isPresent() && searchOptional.get().getIndex() != null ? searchOptional.get().getIndex() : this.getIndex().getStringValue();
        if (StringUtils.nullOrEmpty((String)index.trim()) && inTableSpec.findColumnIndex(this.indexColumn.getStringValue()) == -1) {
            throw new InvalidSettingsException("No index given \u2013 either provide an index or an index column");
        }
        if (inTableSpec.findColumnIndex(this.documentColumn.getStringValue()) == -1) {
            throw new InvalidSettingsException("No documents given \u2013 table does not contain a column '" + String.valueOf(this.documentColumn) + "'.");
        }
    }
}

