/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.port;

import javax.swing.JComponent;
import me.danielesser.knime.elasticsearch.es7.port.Connection;
import me.danielesser.knime.elasticsearch.es7.port.ConnectionPortObjectSpec;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.node.port.PortTypeRegistry;

public class ConnectionPortObject
implements PortObject {
    public static final PortType TYPE = PortTypeRegistry.getInstance().getPortType(ConnectionPortObject.class);
    public static final PortType TYPE_OPTIONAL = PortTypeRegistry.getInstance().getPortType(ConnectionPortObject.class, true);
    private Connection connection;

    public ConnectionPortObject(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public PortObjectSpec getSpec() {
        return new ConnectionPortObjectSpec(this.connection);
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        if (this.connection.getProtocol() != null && this.connection.getHost() != null && this.connection.getPort() != null) {
            sb.append(this.connection.getProtocol());
            sb.append("://");
            sb.append(this.connection.getHost());
            sb.append(":");
            sb.append(this.connection.getPort());
        }
        return sb.toString();
    }

    public JComponent[] getViews() {
        return this.getSpec().getViews();
    }
}

