/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8;

import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.get_alias.IndexAliases;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchDocument;
import me.danielesser.knime.elasticsearch.es8.port.Connection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.knime.core.node.NodeLogger;

public class ElasticsearchClient {
    public static final int ELASTICSEARCH_MAX_RESULT_WINDOW = 10000;
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ElasticsearchClient.class);
    private RestClient restClient;
    private co.elastic.clients.elasticsearch.ElasticsearchClient client;

    public ElasticsearchClient(String protocol, String host, int port) {
        this(protocol, host, port, null, null, false);
    }

    public ElasticsearchClient(String protocol, String host, int port, boolean acceptAllCerts) {
        this(protocol, host, port, null, null, acceptAllCerts);
    }

    public ElasticsearchClient(Connection connection, org.knime.core.node.workflow.CredentialsProvider cp) {
        this(connection.getProtocol(), connection.getHost(), connection.getPort(), connection.getUsername(cp), connection.getPassword(cp), connection.getAcceptAllCerts());
    }

    public ElasticsearchClient(String protocol, String host, int port, String username, String password) {
        this.restClient = this.createRestClient(protocol, host, port, username, password, false);
        this.client = this.createClient(this.restClient);
    }

    public ElasticsearchClient(String protocol, String host, int port, String username, String password, boolean acceptAllCerts) {
        this.restClient = this.createRestClient(protocol, host, port, username, password, acceptAllCerts);
        this.client = this.createClient(this.restClient);
    }

    public String performRequest(String method, String endpoint) throws IOException {
        return this.performRequest(method, endpoint, null);
    }

    public String performRequest(String method, String endpoint, String body) throws IOException {
        Object extendedEndpoint = endpoint.startsWith("/") ? endpoint : "/" + endpoint;
        LOGGER.debugWithFormat("Perform API request: method=%s, endpoint=%s, body=%s", new Object[]{method, extendedEndpoint, body});
        Request request = new Request(method, (String)extendedEndpoint);
        if (body != null) {
            request.setJsonEntity(body);
        }
        return EntityUtils.toString((HttpEntity)this.restClient.performRequest(request).getEntity());
    }

    public String getVersion() {
        try {
            return this.client.info().version().number();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CreateIndexResponse createIndex(String indexName) throws IOException {
        return this.createIndex(indexName, null);
    }

    public CreateIndexResponse createIndex(String indexName, String alias) throws IOException {
        CreateIndexRequest.Builder builder = new CreateIndexRequest.Builder().index(indexName);
        if (alias != null) {
            builder.aliases(alias, a -> a);
        }
        return this.client.indices().create(builder.build());
    }

    public HealthResponse getClusterHealth() throws IOException {
        return this.client.cluster().health(h -> h.timeout(t -> t.time("5s")));
    }

    public SearchResponse<ElasticsearchDocument> performSearchRequest(String index, String route, String query, int from, int size) throws IOException {
        return this.performSearchRequest(index, route, query, size, false);
    }

    public SearchResponse<ElasticsearchDocument> performSearchRequest(String index, String route, String query, int size, boolean scroll) throws IOException {
        SearchRequest.Builder builder = new SearchRequest.Builder().size(Integer.valueOf(size)).query(q -> q.wrapper(w -> w.query(Base64.getEncoder().encodeToString(query.getBytes()))));
        if (index != null && !index.isEmpty()) {
            builder.index(index, new String[0]);
        }
        if (route != null && !route.isEmpty()) {
            builder.routing(route);
        }
        if (scroll) {
            builder.scroll(t -> t.time("2m"));
        }
        return this.client.search(builder.build(), ElasticsearchDocument.class);
    }

    public ScrollResponse<ElasticsearchDocument> performSearchRequest(String scrollId) throws IOException {
        return this.client.scroll(s -> s.scrollId(scrollId).scroll(t -> t.time("2m")), ElasticsearchDocument.class);
    }

    public ClearScrollResponse cancelSearchRequest(String scrollId) throws IOException {
        return this.client.clearScroll(c -> c.scrollId(scrollId, new String[0]));
    }

    public IndexResponse performIndexRequest(String index, String route, String id, ElasticsearchDocument document) throws IOException {
        IndexRequest.Builder builder = new IndexRequest.Builder().index(index).id(id).document((Object)document);
        if (route != null && !route.isEmpty()) {
            builder.routing(route);
        }
        return this.client.index(builder.build());
    }

    public List<String> getIndices() throws IOException {
        return this.getIndices(true);
    }

    public List<String> getIndices(boolean includeAliases) throws IOException {
        return this.client.indices().getAlias().result().entrySet().stream().map(entry -> {
            ArrayList<String> indices = new ArrayList<String>();
            indices.add((String)entry.getKey());
            if (includeAliases) {
                indices.addAll(((IndexAliases)entry.getValue()).aliases().keySet());
            }
            return indices;
        }).flatMap(l -> l.stream()).sorted().distinct().collect(Collectors.toList());
    }

    private RestClient createRestClient(String protocol, String host, int port, final String username, final String password, final boolean acceptAllCerts) {
        LOGGER.debugWithFormat("Create Elasticsearch rest client: protocol=%s, host=%s, port=%d, acceptAllCerts=%b", new Object[]{protocol, host, port, acceptAllCerts});
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        return RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, protocol)}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                HttpAsyncClientBuilder builder = httpClientBuilder;
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username != null ? username : "", password != null ? password : ""));
                builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                if (acceptAllCerts) {
                    try {
                        builder = builder.setSSLContext(SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build());
                    }
                    catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                        LOGGER.warn((Object)"Setting SSLContext failed. \"Accept all certificates\" option could not be enabled.");
                    }
                }
                return builder;
            }
        }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder requestConfigBuilder) {
                return requestConfigBuilder.setConnectTimeout(10000).setSocketTimeout(30000);
            }
        }).build();
    }

    private co.elastic.clients.elasticsearch.ElasticsearchClient createClient(RestClient restClient) {
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        return new co.elastic.clients.elasticsearch.ElasticsearchClient((ElasticsearchTransport)transport);
    }
}

