/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.connect;

import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import java.util.function.Supplier;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.node.IConnectionSettings;
import me.danielesser.knime.elasticsearch.util.KnimeHelper;
import me.danielesser.knime.elasticsearch.view.CustomDefaultNodeSettingsPane;
import me.danielesser.knime.elasticsearch.view.DialogComponentButtonLabel;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentAuthentication;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentNumber;
import org.knime.core.node.defaultnodesettings.DialogComponentString;
import org.knime.core.node.defaultnodesettings.DialogComponentStringSelection;
import org.knime.core.node.defaultnodesettings.SettingsModelAuthentication;
import org.knime.core.node.defaultnodesettings.SettingsModelNumber;

public class ConnectorPanel {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ConnectorPanel.class);

    private ConnectorPanel() {
    }

    public static JPanel add(CustomDefaultNodeSettingsPane pane, IConnectionSettings settings, Supplier<ElasticsearchClient> clientSupplier) {
        JPanel panel = pane.createGroup("Connection");
        pane.setHorizontalPlacement(true);
        pane.addDialogComponent((DialogComponent)new DialogComponentStringSelection(settings.getProtocol(), "Protocol:", new String[]{"http", "https"}));
        pane.addDialogComponent((DialogComponent)new DialogComponentString(settings.getHost(), "Host:", false, 30));
        pane.addDialogComponent((DialogComponent)new DialogComponentNumber((SettingsModelNumber)settings.getPort(), "Port:", (Number)1, 5));
        pane.setHorizontalPlacement(false);
        pane.addDialogComponent((DialogComponent)new DialogComponentBoolean(settings.getAcceptAllCerts(), "Accept all SSL certificates (only enable this if you understand the implications!)"));
        pane.setHorizontalPlacement(false);
        DialogComponentAuthentication auth = new DialogComponentAuthentication(settings.getAuth(), "Authentication", new SettingsModelAuthentication.AuthenticationType[]{SettingsModelAuthentication.AuthenticationType.USER_PWD, SettingsModelAuthentication.AuthenticationType.CREDENTIALS, SettingsModelAuthentication.AuthenticationType.NONE});
        pane.addDialogComponent((DialogComponent)auth);
        DialogComponentButtonLabel testButton = new DialogComponentButtonLabel("Test Connection", "");
        testButton.addActionListener(event -> {
            testButton.setLabelText("<html>Testing connection...</html>");
            new Thread(() -> ConnectorPanel.lambda$1((Supplier)clientSupplier, testButton)).start();
        });
        pane.addDialogComponent((DialogComponent)testButton);
        JPanel authParent = auth.getComponentPanel();
        authParent.setLayout(new BoxLayout(authParent, 1));
        return panel;
    }

    private static /* synthetic */ void lambda$1(Supplier supplier, DialogComponentButtonLabel dialogComponentButtonLabel) {
        try {
            ElasticsearchClient client = (ElasticsearchClient)supplier.get();
            HealthResponse clusterHealth = client.getClusterHealth();
            if (clusterHealth.timedOut()) {
                throw new Exception("Connection timed out. The cluster doesn't seem to be reachable.");
            }
            String version = client.getVersion();
            boolean isValid = version == null || version.startsWith("8.");
            KnimeHelper.runInDisplayThread(() -> {
                Object message = isValid ? "<html><font color='green'>Connection was successful.</font></html>" : "<html><font color='green'>Connection was successful.</font> <font color='orange'>Warning: The Elasticsearch cluster " + version + " and your<br/>Elasticsearch Nodes might not be 100% compatible. We recommend<br/>using the version of the Elasticsearch Nodes that match your cluster version.</font></html>";
                dialogComponentButtonLabel.setLabelText((String)message);
            });
        }
        catch (Exception e) {
            LOGGER.warnWithFormat("Connection failed: %s", new Object[]{e.getMessage()});
            KnimeHelper.runInDisplayThread(() -> dialogComponentButtonLabel.setLabelText("<html><font color='red'>Error connecting to Elasticsearch. Check your configuration.</font></html>"));
        }
    }
}

