/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.port;

import java.io.Serializable;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.node.IConnectionSettings;
import org.knime.core.node.defaultnodesettings.SettingsModelAuthentication;
import org.knime.core.node.workflow.CredentialsProvider;

public class Connection
implements Serializable {
    private static final long serialVersionUID = -2645342879892565959L;
    private SettingsModelAuthentication.AuthenticationType authenticationType;
    private String username;
    private String password;
    private String credentials;
    private String protocol;
    private String host;
    private Integer port;
    private boolean acceptAllCerts;

    protected Connection(Builder builder) {
        this.authenticationType = builder.authenticationType;
        this.username = builder.username;
        this.password = builder.password;
        this.credentials = builder.credentials;
        this.protocol = builder.protocol;
        this.host = builder.host;
        this.port = builder.port;
        this.acceptAllCerts = builder.acceptAllCerts;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public SettingsModelAuthentication.AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getUsername(CredentialsProvider cp) {
        switch (this.authenticationType) {
            case CREDENTIALS: {
                return cp.get(this.credentials).getLogin();
            }
            case NONE: 
            case USER_PWD: {
                return this.username;
            }
        }
        throw new IllegalArgumentException("Authentication method is not supported");
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getPassword(CredentialsProvider cp) {
        switch (this.authenticationType) {
            case CREDENTIALS: {
                return cp.get(this.credentials).getPassword();
            }
            case NONE: 
            case USER_PWD: {
                return this.password;
            }
        }
        throw new IllegalArgumentException("Authentication method is not supported");
    }

    public boolean getAcceptAllCerts() {
        return this.acceptAllCerts;
    }

    public ElasticsearchClient createClient(CredentialsProvider cp) {
        return new ElasticsearchClient(this.getProtocol(), this.getHost(), this.getPort(), this.getUsername(cp), this.getPassword(cp), this.getAcceptAllCerts());
    }

    public static class Builder {
        private SettingsModelAuthentication.AuthenticationType authenticationType;
        private String username;
        private String password;
        private String credentials;
        private String protocol;
        private String host;
        private Integer port;
        private boolean acceptAllCerts;

        public Builder() {
        }

        public Builder(Connection connection) {
            this.authenticationType = connection.authenticationType;
            this.username = connection.username;
            this.password = connection.password;
            this.credentials = connection.credentials;
            this.protocol = connection.protocol;
            this.host = connection.host;
            this.port = connection.port;
            this.acceptAllCerts = connection.acceptAllCerts;
        }

        public Builder(IConnectionSettings settings) {
            this.authenticationType = settings.getAuth().getAuthenticationType();
            this.username = settings.getAuth().getUsername();
            this.password = settings.getAuth().getPassword();
            this.credentials = settings.getAuth().getCredential();
            this.protocol = settings.getProtocol().getStringValue();
            this.host = settings.getHost().getStringValue();
            this.port = settings.getPort().getIntValue();
            this.acceptAllCerts = settings.getAcceptAllCerts().getBooleanValue();
        }

        public Builder authenticationType(SettingsModelAuthentication.AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder acceptAllCerts(boolean acceptAllCerts) {
            this.acceptAllCerts = acceptAllCerts;
            return this;
        }

        public Connection build() {
            return new Connection(this);
        }
    }
}

