/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.util;

import com.google.gson.Gson;
import java.util.Map;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean nullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean notNullOrEmpty(String str) {
        return !StringUtils.nullOrEmpty(str);
    }

    public static boolean validJson(String str) {
        if (StringUtils.nullOrEmpty(str)) {
            return false;
        }
        try {
            new Gson().fromJson(str, Object.class);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String stripOuterQueryFromJSON(String input) {
        try {
            Gson gson = new Gson();
            Map fromJson = (Map)gson.fromJson(input, Map.class);
            if (fromJson.containsKey("query")) {
                return gson.toJson(fromJson.get("query"));
            }
            return input;
        }
        catch (Exception exception) {
            return input;
        }
    }
}

