/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.internal.Activator;
import com.verhas.licensor.License;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import javax.swing.ImageIcon;
import org.osgi.framework.Bundle;

public final class LicensableProduct {
    final String id;
    private final URL publicKeyUrl;
    private final Bundle bundle;
    private final LicenseHelper licenseHelper;
    private final ImageIcon icon;

    LicensableProduct(String id, URL publicKeyUrl, Bundle bundle, LicenseHelper licenseHelper, ImageIcon icon) {
        this.id = id;
        this.publicKeyUrl = publicKeyUrl;
        this.bundle = bundle;
        this.licenseHelper = licenseHelper;
        this.icon = icon;
    }

    public LicenseInformation parseLicense(String licenseString) throws LicenseException {
        License license = new License();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream inputStream = this.publicKeyUrl.openConnection().getInputStream();){
                license.loadKeyRing(inputStream, this.licenseHelper.getDigest());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new LicenseException(LicenseException.Reason.OTHER, "Error when reading keyring.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LicenseException(LicenseException.Reason.OTHER, "Error when verifying keyring.");
        }
        try {
            license.setLicenseEncoded(licenseString);
        }
        catch (Exception exception) {
            throw new LicenseException(LicenseException.Reason.INVALID_LICENSE, "The license is invalid.");
        }
        if (!license.isVerified()) {
            throw new LicenseException(LicenseException.Reason.INVALID_LICENSE, "The license is invalid.");
        }
        return new LicenseInformation(license, this.licenseHelper);
    }

    public LicenseInformation getLicense() throws LicenseException {
        String licenseString = Activator.getDefault().getPreferenceStore().getString(this.id);
        if (licenseString.isEmpty()) {
            String message = String.format("No license for \u201c%s\u201d specified. Please enter a valid license code in the plugin\u2019s preference page.", this.getBundleName());
            throw new LicenseException(LicenseException.Reason.NO_LICENSE_SPECIFIED, message);
        }
        return this.parseLicense(licenseString);
    }

    public void setLicense(String licenseString) {
        String value = licenseString != null ? licenseString : "";
        Activator.getDefault().getPreferenceStore().setValue(this.id, value);
    }

    public String getId() {
        return this.id;
    }

    public String getBundleName() {
        Dictionary headers = this.bundle.getHeaders();
        return (String)headers.get("Bundle-Name");
    }

    Bundle getBundle() {
        return this.bundle;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }
}

