/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.port;

import java.io.Serializable;
import me.danielesser.knime.elasticsearch.es7.port.Connection;

public class Search
extends Connection
implements Serializable {
    private static final long serialVersionUID = -2645342879892565959L;
    private String index;
    private String route;
    private Integer from;
    private Integer size;
    private String query;

    protected Search(Builder builder) {
        super(builder);
        this.index = builder.index;
        this.route = builder.route;
        this.from = builder.from;
        this.size = builder.size;
        this.query = builder.query;
    }

    public String getIndex() {
        return this.index;
    }

    public String getRoute() {
        return this.route;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getSize() {
        return this.size;
    }

    public String getQuery() {
        return this.query;
    }

    public static class Builder
    extends Connection.Builder {
        private String index;
        private String route;
        private Integer from;
        private Integer size;
        private String query;

        public Builder() {
        }

        public Builder(Connection connection) {
            super(connection);
        }

        public Builder(Search search) {
            super(search);
            this.index = search.index;
            this.route = search.route;
            this.from = search.from;
            this.size = search.size;
            this.query = search.query;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder route(String route) {
            this.route = route;
            return this;
        }

        public Builder from(int from) {
            this.from = from;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

