/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es7.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;

public final class SerializationHelper {
    private SerializationHelper() {
    }

    public static <T extends Serializable> T readObject(InputStream inputStream) throws IOException {
        ObjectInputStream dais = new ObjectInputStream(inputStream);
        try {
            return (T)((Serializable)dais.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find setting class(es), although we are in the same package", e);
        }
    }

    public static <T extends Serializable> T readObject(NodeSettingsRO settings, String key) throws InvalidSettingsException {
        if (!settings.containsKey(key)) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(settings.getByteArray(key));
            return SerializationHelper.readObject(bis);
        }
        catch (Exception e) {
            throw new InvalidSettingsException("Cannot read object", (Throwable)e);
        }
    }

    public static void writeObject(NodeSettingsWO settings, String key, Serializable serializable) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SerializationHelper.writeObject(bos, serializable);
            bos.close();
            settings.addByteArray(key, bos.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot serialize the object locally.", e);
        }
    }

    public static void writeObject(OutputStream out, Serializable serializable) throws IOException {
        ObjectOutputStream daos = new ObjectOutputStream(out);
        daos.writeObject(serializable);
        daos.flush();
    }
}

