/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.connect;

import me.danielesser.knime.elasticsearch.es8.node.IConnectionSettings;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelAuthentication;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelInteger;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class ConnectorSettings
extends AbstractSettings
implements IConnectionSettings {
    private static final String AUTH_CFG_KEY = "auth";
    private static final String PROTOCOL_CFG_KEY = "protocol";
    private static final String HOST_CFG_KEY = "host";
    private static final String PORT_CFG_KEY = "port";
    private static final String ACCEPT_ALL_CERTS_CFG_KEY = "acceptAllCertificates";
    private static final SettingsModelAuthentication.AuthenticationType AUTH_CFG_DEFAULT = SettingsModelAuthentication.AuthenticationType.NONE;
    private static final String PROTOCOL_CFG_DEFAULT = "http";
    private static final String HOST_CFG_DEFAULT = "localhost";
    private static final int PORT_CFG_DEFAULT = 9200;
    private static final boolean ACCEPT_ALL_CERTS_CFG_DEFAULT = false;
    private final SettingsModelAuthentication auth = new SettingsModelAuthentication("auth", AUTH_CFG_DEFAULT);
    private final SettingsModelString protocol = new SettingsModelString("protocol", "http");
    private final SettingsModelString host = new SettingsModelString("host", "localhost");
    private final SettingsModelInteger port = new SettingsModelInteger("port", 9200);
    private final SettingsModelBoolean acceptAllCerts = new SettingsModelBoolean("acceptAllCertificates", false);

    public ConnectorSettings() {
        this.addSettingsModel((SettingsModel)this.auth);
        this.addSettingsModel((SettingsModel)this.protocol);
        this.addSettingsModel((SettingsModel)this.host);
        this.addSettingsModel((SettingsModel)this.port);
        this.addSettingsModel((SettingsModel)this.acceptAllCerts);
    }

    @Override
    public SettingsModelAuthentication getAuth() {
        return this.auth;
    }

    @Override
    public SettingsModelString getProtocol() {
        return this.protocol;
    }

    @Override
    public SettingsModelString getHost() {
        return this.host;
    }

    @Override
    public SettingsModelInteger getPort() {
        return this.port;
    }

    @Override
    public SettingsModelBoolean getAcceptAllCerts() {
        return this.acceptAllCerts;
    }

    public void validate() throws InvalidSettingsException {
        if (StringUtils.nullOrEmpty((String)this.getProtocol().getStringValue().trim())) {
            throw new InvalidSettingsException("No protocol given");
        }
        if (StringUtils.nullOrEmpty((String)this.getHost().getStringValue().trim())) {
            throw new InvalidSettingsException("No host given");
        }
    }
}

