/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.read;

import java.util.Optional;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.node.connect.ConnectorPanel;
import me.danielesser.knime.elasticsearch.es8.node.index.SearchIndexPanel;
import me.danielesser.knime.elasticsearch.es8.node.query.SearchQueryPanel;
import me.danielesser.knime.elasticsearch.es8.node.read.ReaderSettings;
import me.danielesser.knime.elasticsearch.es8.node.route.SearchRoutePanel;
import me.danielesser.knime.elasticsearch.es8.port.Connection;
import me.danielesser.knime.elasticsearch.es8.port.Search;
import me.danielesser.knime.elasticsearch.es8.util.PortHelper;
import me.danielesser.knime.elasticsearch.view.CustomDefaultNodeSettingsPane;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentLabel;
import org.knime.core.node.port.PortObjectSpec;

public class ReaderNodeDialog
extends CustomDefaultNodeSettingsPane {
    private ReaderSettings settings = new ReaderSettings();
    private JPanel connectionPanel = ConnectorPanel.add(this, this.settings, () -> this.getElasticsearchClient());
    private JPanel indexPanel = SearchIndexPanel.add(this, this.settings.getIndex(), () -> this.getElasticsearchClient());
    private JPanel routePanel = SearchRoutePanel.add(this, this.settings.getRoute());
    private JPanel queryPanel = SearchQueryPanel.add(this, this.settings.getFrom(), this.settings.getSize(), this.settings.getQuery());
    private JPanel emptyPanel = this.createGroup("Configuration");
    private Optional<Connection> connectionOptional;

    protected ReaderNodeDialog() {
        this.addDialogComponent((DialogComponent)new DialogComponentLabel("No configuration necessary."));
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.connectionOptional = PortHelper.getConnection(specs);
        this.connectionPanel.setVisible(!this.connectionOptional.isPresent());
        Optional<Search> search = PortHelper.getSearch(specs);
        this.indexPanel.setVisible(!search.isPresent() || search.get().getIndex() == null);
        this.routePanel.setVisible(!search.isPresent() || search.get().getRoute() == null);
        this.queryPanel.setVisible(!search.isPresent() || search.get().getQuery() == null);
        this.emptyPanel.setVisible(!this.connectionPanel.isVisible() && !this.indexPanel.isVisible() && !this.routePanel.isVisible() && !this.queryPanel.isVisible());
    }

    private ElasticsearchClient getElasticsearchClient() {
        Connection connection = this.connectionOptional.orElse(new Connection.Builder(this.settings).build());
        return new ElasticsearchClient(connection, this.getCredentialsProvider());
    }
}

