/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.read;

import co.elastic.clients.elasticsearch.core.ScrollResponse;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import java.util.List;
import java.util.Optional;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchDocument;
import me.danielesser.knime.elasticsearch.es8.node.read.ReaderSettings;
import me.danielesser.knime.elasticsearch.es8.port.Connection;
import me.danielesser.knime.elasticsearch.es8.port.ConnectionPortObject;
import me.danielesser.knime.elasticsearch.es8.port.Search;
import me.danielesser.knime.elasticsearch.es8.util.PortHelper;
import me.danielesser.knime.elasticsearch.node.AbstractNodeModel;
import me.danielesser.knime.elasticsearch.node.AbstractSettings;
import me.danielesser.knime.elasticsearch.util.LicenseChecker;
import me.danielesser.knime.elasticsearch.util.StringUtils;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;

public class ReaderNodeModel
extends AbstractNodeModel<ReaderSettings> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(ReaderNodeModel.class);
    private static final String ES_FIELD_INDEX = "_index";
    private static final String ES_FIELD_ID = "_id";
    private static final String ES_FIELD_SCORE = "_score";
    private static final String ES_FIELD_SOURCE = "_source";

    public ReaderNodeModel() {
        super(new PortType[]{ConnectionPortObject.TYPE_OPTIONAL}, new PortType[]{BufferedDataTable.TYPE}, (AbstractSettings)new ReaderSettings());
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        if (!PortHelper.getConnection(inSpecs).isPresent() && !PortHelper.getSearch(inSpecs).isPresent()) {
            ((ReaderSettings)this.getSettings()).validate(inSpecs);
        }
        return new DataTableSpec[]{this.createDataTableSpec()};
    }

    protected BufferedDataTable[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        LicenseChecker.getLicense();
        Optional<Search> searchOptional = PortHelper.getSearch(inData);
        if (searchOptional.isPresent()) {
            Search search = searchOptional.get();
            String index = search.getIndex() != null ? search.getIndex() : ((ReaderSettings)this.getSettings()).getIndex().getStringValue();
            String route = search.getRoute() != null ? search.getRoute() : ((ReaderSettings)this.getSettings()).getRoute().getStringValue();
            int from = search.getFrom() != null ? search.getFrom().intValue() : ((ReaderSettings)this.getSettings()).getFrom().getIntValue();
            int size = search.getSize() != null ? search.getSize().intValue() : ((ReaderSettings)this.getSettings()).getSize().getIntValue();
            String query = search.getQuery() != null ? search.getQuery() : ((ReaderSettings)this.getSettings()).getQuery().getStringValue();
            return this.query(exec, search.getProtocol(), search.getHost(), search.getPort(), search.getUsername(this.getCredentialsProvider()), search.getPassword(this.getCredentialsProvider()), search.getAcceptAllCerts(), index, route, from, size, query);
        }
        Optional<Connection> connectionOptional = PortHelper.getConnection(inData);
        if (connectionOptional.isPresent()) {
            Connection connection = connectionOptional.get();
            return this.query(exec, connection.getProtocol(), connection.getHost(), connection.getPort(), connection.getUsername(this.getCredentialsProvider()), connection.getPassword(this.getCredentialsProvider()), connection.getAcceptAllCerts(), ((ReaderSettings)this.getSettings()).getIndex().getStringValue(), ((ReaderSettings)this.getSettings()).getRoute().getStringValue(), ((ReaderSettings)this.getSettings()).getFrom().getIntValue(), ((ReaderSettings)this.getSettings()).getSize().getIntValue(), ((ReaderSettings)this.getSettings()).getQuery().getStringValue());
        }
        return this.query(exec, ((ReaderSettings)this.getSettings()).getProtocol().getStringValue(), ((ReaderSettings)this.getSettings()).getHost().getStringValue(), ((ReaderSettings)this.getSettings()).getPort().getIntValue(), ((ReaderSettings)this.getSettings()).getAuth().getUserName(this.getCredentialsProvider()), ((ReaderSettings)this.getSettings()).getAuth().getPassword(this.getCredentialsProvider()), ((ReaderSettings)this.getSettings()).getAcceptAllCerts().getBooleanValue(), ((ReaderSettings)this.getSettings()).getIndex().getStringValue(), ((ReaderSettings)this.getSettings()).getRoute().getStringValue(), ((ReaderSettings)this.getSettings()).getFrom().getIntValue(), ((ReaderSettings)this.getSettings()).getSize().getIntValue(), ((ReaderSettings)this.getSettings()).getQuery().getStringValue());
    }

    private BufferedDataTable[] query(ExecutionContext exec, String protocol, String host, int port, String username, String password, boolean acceptAllCerts, String index, String route, int from, int size, String query) throws Exception {
        exec.setProgress("Preparing query operation\u2026");
        try {
            ElasticsearchClient client = new ElasticsearchClient(protocol, host, port, username, password, acceptAllCerts);
            int updatedSize = size == 0 ? Integer.MAX_VALUE : size;
            String updatedQuery = StringUtils.stripOuterQueryFromJSON((String)query);
            BufferedDataContainer container = from + updatedSize <= 10000 ? this.singleQuery(exec, client, index, route, from, updatedSize, updatedQuery) : this.scrollQuery(exec, client, index, route, from, updatedSize, updatedQuery);
            container.close();
            return new BufferedDataTable[]{container.getTable()};
        }
        catch (Exception e) {
            LOGGER.errorWithFormat("Error while performing query: %s", new Object[]{e.getMessage()});
            throw e;
        }
    }

    private BufferedDataContainer singleQuery(ExecutionContext exec, ElasticsearchClient client, String index, String route, int from, int size, String query) throws Exception {
        int rowNumber = 0;
        BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec());
        SearchResponse<ElasticsearchDocument> response = client.performSearchRequest(index, route, query, from, size);
        List searchHits = response.hits().hits();
        for (Hit hit : searchHits) {
            container.addRowToTable(this.createRow((Hit<ElasticsearchDocument>)hit, rowNumber));
            exec.checkCanceled();
            exec.setProgress((double)rowNumber++ / (double)size, "Reading search result #" + rowNumber);
        }
        this.setFlowVariables(response);
        return container;
    }

    private BufferedDataContainer scrollQuery(ExecutionContext exec, ElasticsearchClient client, String index, String route, int from, int size, String query) throws Exception {
        int rowNumber = 0;
        int totalTook = 0;
        int count = 0;
        int totalSize = from + size;
        int batchSize = (int)Math.ceil((double)totalSize / (double)((int)Math.ceil((double)totalSize / 10000.0)));
        BufferedDataContainer container = exec.createDataContainer(this.createDataTableSpec());
        SearchResponse<ElasticsearchDocument> searchResponse = client.performSearchRequest(index, route, query, batchSize, true);
        String scrollId = searchResponse.scrollId();
        List searchHits = searchResponse.hits().hits();
        totalTook = (int)((long)totalTook + searchResponse.took());
        ScrollResponse<ElasticsearchDocument> scrollResponse = null;
        while (searchHits != null && searchHits.size() > 0 && rowNumber < size) {
            for (Hit hit : searchHits) {
                if (count >= from) {
                    container.addRowToTable(this.createRow((Hit<ElasticsearchDocument>)hit, rowNumber));
                    exec.setProgress((double)rowNumber++ / (double)size, "Reading search result #" + rowNumber);
                }
                exec.checkCanceled();
                ++count;
            }
            scrollResponse = client.performSearchRequest(scrollId);
            scrollId = scrollResponse.scrollId();
            searchHits = scrollResponse.hits().hits();
            totalTook = (int)((long)totalTook + scrollResponse.took());
        }
        client.cancelSearchRequest(scrollId);
        if (scrollResponse != null) {
            this.setFlowVariables(scrollResponse);
        } else {
            this.setFlowVariables(searchResponse);
        }
        this.setFlowVariable("es_took", totalTook);
        return container;
    }

    private DataTableSpec createDataTableSpec() {
        return new DataTableSpec(new DataColumnSpec[]{new DataColumnSpecCreator(ES_FIELD_INDEX, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_ID, StringCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_SCORE, DoubleCell.TYPE).createSpec(), new DataColumnSpecCreator(ES_FIELD_SOURCE, JSONCell.TYPE).createSpec()});
    }

    private DataRow createRow(Hit<ElasticsearchDocument> hit, int rowNumber) throws Exception {
        return new DefaultRow(new RowKey("Row" + rowNumber), new DataCell[]{new StringCell(hit.index()), new StringCell(hit.id()), new DoubleCell(hit.score().doubleValue()), ((ElasticsearchDocument)hit.source()).toDataCell()});
    }

    private void setFlowVariables(SearchResponse<ElasticsearchDocument> response) {
        this.setFlowVariable("es_took", (int)response.took());
        this.setFlowVariable("es_timed_out", Boolean.toString(response.timedOut()));
        this.setFlowVariable("es_hits_total_value", (int)response.hits().total().value());
        this.setFlowVariable("es_hits_max_score", response.hits().maxScore().intValue());
        this.setFlowVariable("es_shards_total", response.shards().total().intValue());
        this.setFlowVariable("es_shards_successful", response.shards().successful().intValue());
        this.setFlowVariable("es_shards_skipped", response.shards().skipped().intValue());
        this.setFlowVariable("es_shards_failed", response.shards().failed().intValue());
    }

    private void setFlowVariables(ScrollResponse<ElasticsearchDocument> response) {
        this.setFlowVariable("es_took", (int)response.took());
        this.setFlowVariable("es_timed_out", Boolean.toString(response.timedOut()));
        this.setFlowVariable("es_hits_total_value", (int)response.hits().total().value());
        this.setFlowVariable("es_hits_max_score", response.hits().maxScore().intValue());
        this.setFlowVariable("es_shards_total", response.shards().total().intValue());
        this.setFlowVariable("es_shards_successful", response.shards().successful().intValue());
        this.setFlowVariable("es_shards_skipped", response.shards().skipped().intValue());
        this.setFlowVariable("es_shards_failed", response.shards().failed().intValue());
    }
}

