/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.es8.node.write;

import java.util.Optional;
import javax.swing.JPanel;
import me.danielesser.knime.elasticsearch.es8.ElasticsearchClient;
import me.danielesser.knime.elasticsearch.es8.node.connect.ConnectorPanel;
import me.danielesser.knime.elasticsearch.es8.node.index.SearchIndexPanel;
import me.danielesser.knime.elasticsearch.es8.node.route.SearchRoutePanel;
import me.danielesser.knime.elasticsearch.es8.node.write.WriterSettings;
import me.danielesser.knime.elasticsearch.es8.port.Connection;
import me.danielesser.knime.elasticsearch.es8.port.Search;
import me.danielesser.knime.elasticsearch.es8.util.PortHelper;
import me.danielesser.knime.elasticsearch.view.CustomDefaultNodeSettingsPane;
import org.knime.core.data.StringValue;
import org.knime.core.data.json.JSONValue;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.DialogComponentBoolean;
import org.knime.core.node.defaultnodesettings.DialogComponentColumnNameSelection;
import org.knime.core.node.port.PortObjectSpec;

public class WriterNodeDialog
extends CustomDefaultNodeSettingsPane {
    private WriterSettings settings = new WriterSettings();
    private JPanel connectionPanel = ConnectorPanel.add(this, this.settings, () -> this.getElasticsearchClient());
    private JPanel indexPanel = SearchIndexPanel.add(this, this.settings.getIndex(), () -> this.getElasticsearchClient(), (DialogComponent)new DialogComponentColumnNameSelection(this.settings.getIndexColumn(), "Column with index per document", 1, false, true, new Class[]{StringValue.class}));
    private JPanel routePanel = SearchRoutePanel.add(this, this.settings.getRoute());
    private Optional<Connection> connectionOptional;

    public WriterNodeDialog() {
        this.createGroup("Documents");
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settings.getDocumentColumn(), "Column with documents", 1, true, new Class[]{JSONValue.class}));
        this.addDialogComponent((DialogComponent)new DialogComponentColumnNameSelection(this.settings.getIdColumn(), "Column with unique identifiers", 1, false, true, new Class[]{StringValue.class}));
        this.createGroup("Settings");
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.settings.getAppendResultColumns(), "Append result columns"));
        this.addDialogComponent((DialogComponent)new DialogComponentBoolean(this.settings.getFailOnError(), "Fail on error"));
    }

    public void loadAdditionalSettingsFrom(NodeSettingsRO settings, PortObjectSpec[] specs) throws NotConfigurableException {
        this.connectionOptional = PortHelper.getConnection(specs);
        this.connectionPanel.setVisible(!this.connectionOptional.isPresent());
        Optional<Search> search = PortHelper.getSearch(specs);
        this.indexPanel.setVisible(!search.isPresent() || search.get().getIndex() == null);
        this.routePanel.setVisible(!search.isPresent() || search.get().getRoute() == null);
    }

    private ElasticsearchClient getElasticsearchClient() {
        Connection connection = this.connectionOptional.orElse(new Connection.Builder(this.settings).build());
        return new ElasticsearchClient(connection, this.getCredentialsProvider());
    }
}

