/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.danielesser.knime.elasticsearch.util.KnimeHelper;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.port.PortObjectSpec;

public abstract class AbstractSettings {
    private final List<SettingsModel> settingsModels = new ArrayList<SettingsModel>();

    public final void saveSettingsTo(NodeSettingsWO settings) {
        this.getSettingsModels().forEach(m -> m.saveSettingsTo(settings));
    }

    public final void loadSettingsFrom(NodeSettingsRO settings) {
        for (SettingsModel model : this.getSettingsModels()) {
            KnimeHelper.loadSettingsFrom(settings, model);
        }
    }

    public final void validateSettings(NodeSettingsRO settings) {
        for (SettingsModel model : this.getSettingsModels()) {
            KnimeHelper.validateSettings(settings, model);
        }
    }

    public void validate(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        this.validate();
    }

    public void validate(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        this.validate();
    }

    public void validate() throws InvalidSettingsException {
    }

    protected final Collection<SettingsModel> getSettingsModels() {
        return Collections.unmodifiableCollection(this.settingsModels);
    }

    protected final void addSettingsModel(SettingsModel model) {
        Objects.requireNonNull(model, "model was null");
        this.settingsModels.add(model);
    }
}

