/*
 * Decompiled with CFR 0.152.
 */
package me.danielesser.knime.elasticsearch.view;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;

public class DialogComponentRSyntaxTextArea
extends DialogComponent {
    private static final int FIELD_ROWS = 20;
    private static final int FIELD_COLUMNS = 60;
    private final JLabel label;
    private final RSyntaxTextArea textArea;

    public DialogComponentRSyntaxTextArea(SettingsModelString stringModel, String label) {
        this(stringModel, label, 20, 60);
    }

    public DialogComponentRSyntaxTextArea(SettingsModelString stringModel, String label, int rows, int columns) {
        super((SettingsModel)stringModel);
        this.getComponentPanel().setLayout(new BorderLayout());
        this.label = new JLabel(label);
        this.getComponentPanel().add((Component)this.label, "North");
        this.textArea = new RSyntaxTextArea(rows, columns);
        this.textArea.setSyntaxEditingStyle("text/json");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setTabSize(2);
        this.textArea.setTabsEmulated(true);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.textArea);
        this.getComponentPanel().add((Component)sp);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ((SettingsModelString)DialogComponentRSyntaxTextArea.this.getModel()).setStringValue(DialogComponentRSyntaxTextArea.this.textArea.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ((SettingsModelString)DialogComponentRSyntaxTextArea.this.getModel()).setStringValue(DialogComponentRSyntaxTextArea.this.textArea.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ((SettingsModelString)DialogComponentRSyntaxTextArea.this.getModel()).setStringValue(DialogComponentRSyntaxTextArea.this.textArea.getText());
            }
        });
        this.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DialogComponentRSyntaxTextArea.this.updateComponent();
            }
        });
        this.updateComponent();
    }

    protected void updateComponent() {
        String str = ((SettingsModelString)this.getModel()).getStringValue();
        if (!this.textArea.getText().equals(str)) {
            this.textArea.setText(str);
        }
        this.setEnabledComponents(this.getModel().isEnabled());
    }

    protected void validateSettingsBeforeSave() throws InvalidSettingsException {
        ((SettingsModelString)this.getModel()).setStringValue(this.textArea.getText());
    }

    protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
    }

    protected void setEnabledComponents(boolean enabled) {
        this.textArea.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.label.setToolTipText(text);
        this.textArea.setToolTipText(text);
    }
}

