/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.example.shuffle;

import com.nodepit.knime.example.LicenseChecker;
import com.nodepit.knime.example.shuffle.ShuffleNodeParameters;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CellFactory;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.data.container.SingleCellFactory;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.util.UniqueNameGenerator;
import org.knime.node.DefaultModel;

class ShuffleNodeModel {
    ShuffleNodeModel() {
    }

    static void rearrangeColumns(DefaultModel.RearrangeColumnsInput in, DefaultModel.RearrangeColumnsOutput out) throws InvalidSettingsException {
        LicenseChecker.getLicense();
        DataTableSpec spec = in.getDataTableSpec();
        ShuffleNodeParameters parameters = (ShuffleNodeParameters)in.getParameters();
        int inputIndex = spec.findColumnIndex(parameters.inputColumn);
        if (inputIndex < 0) {
            throw new InvalidSettingsException("The table contains no such column '" + parameters.inputColumn + "'.");
        }
        String newColumnName = new UniqueNameGenerator(spec).newName(spec.getColumnSpec(inputIndex).getName() + " (shuffled)");
        ColumnRearranger rearranger = new ColumnRearranger(spec);
        rearranger.append((CellFactory)new ShuffleCellFactory(newColumnName, inputIndex));
        out.setColumnRearranger(rearranger);
    }

    private static String shuffle(String input) {
        List<Character> chars = input.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toList());
        Collections.shuffle(chars);
        StringBuilder sb = new StringBuilder();
        chars.forEach(sb::append);
        return sb.toString();
    }

    static final class ShuffleCellFactory
    extends SingleCellFactory {
        private final int inputIndex;

        ShuffleCellFactory(String newColumnName, int inputIndex) {
            super(new DataColumnSpecCreator(newColumnName, StringCell.TYPE).createSpec());
            this.inputIndex = inputIndex;
        }

        public DataCell getCell(DataRow row) {
            DataCell inputCell = row.getCell(this.inputIndex);
            if (inputCell.isMissing()) {
                return DataType.getMissingCell();
            }
            String inputString = ((StringValue)inputCell).getStringValue();
            String shuffledString = ShuffleNodeModel.shuffle(inputString);
            return new StringCell(shuffledString);
        }
    }
}

