/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.knime.example;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.LicenseManager;
import java.util.Iterator;
import java.util.Map;

public class LicenseChecker {
    public static final String PRODUCT_ID = "com.nodepit.knime.example";
    private static final String SERVER_LICENSE_FEATURE_KEY = "knimeServer";
    private static final byte[] DIGEST = new byte[]{-15, 89, -3, -9, -42, -66, 116, 6, -14, -53, 4, -6, 43, -66, 27, 51, -52, -16, -108, -88, 86, -26, -98, 37, -83, 15, 68, 93, 75, -24, -42, 32, 19, -37, -79, 77, -88, 8, 48, 122, -28, 69, -57, 14, 18, -16, -118, 102, -62, 2, 16, -31, -79, -26, 90, 13, -42, 62, -6, 32, -25, -54, -35, -1};

    public static LicenseInformation getLicense() {
        LicenseInformation license;
        try {
            license = LicenseManager.getProduct((String)PRODUCT_ID).getLicense();
        }
        catch (LicenseException licenseException) {
            throw new IllegalStateException("No license specified. Please obtain a license and enter it on the Example Nodes preference page in order to use this node.");
        }
        if (LicenseChecker.isRunningOnKNIMEServer() && !license.getBooleanFeature(SERVER_LICENSE_FEATURE_KEY)) {
            throw new IllegalStateException("The specified license is not valid for a KNIME Server environment. Please obtain a server license and enter it on the Example Nodes preference page in order to use this node on a KNIME Server.");
        }
        return license;
    }

    private static boolean isRunningOnKNIMEServer() {
        String enterpriseApplicationClass = "com.knime.enterprise.executor.KNIMEExecutorApplication";
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Iterator<StackTraceElement[]> iterator = stackTraces.values().iterator();
        while (iterator.hasNext()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = iterator.next();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().startsWith(enterpriseApplicationClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private LicenseChecker() {
    }

    public static final class Helper
    implements LicenseHelper {
        public byte[] getDigest() {
            return DIGEST;
        }
    }
}

