/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing.nodes;

import com.nodepit.licensing.LicensableProduct;
import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseManager;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

class InputLicenseKeySettings {
    private static final String LICENSE_KEY_START = "-----BEGIN LICENSE-----";
    private static final String LICENSE_KEY_END = "-----END LICENSE-----";
    final SettingsModelString productIdentifier = new SettingsModelString("productIdentifier", null);
    final SettingsModelString licenseKey = new SettingsModelString("licenseKey", null);

    InputLicenseKeySettings() {
    }

    void validateLicense() throws InvalidSettingsException {
        this.internalValidateAndOptionallySetLicense(false);
    }

    void validateAndSetLicense() throws InvalidSettingsException {
        this.internalValidateAndOptionallySetLicense(true);
    }

    private void internalValidateAndOptionallySetLicense(boolean setLicense) throws InvalidSettingsException {
        String licenseKey = this.licenseKey.getStringValue().trim();
        if (!licenseKey.startsWith(LICENSE_KEY_START)) {
            throw new InvalidSettingsException("License key should start with -----BEGIN LICENSE-----");
        }
        if (!licenseKey.endsWith(LICENSE_KEY_END)) {
            throw new InvalidSettingsException("License key should end with -----END LICENSE-----");
        }
        if (licenseKey.split("\n").length < 5) {
            throw new InvalidSettingsException("License key should contain several new line characters!");
        }
        try {
            LicensableProduct product = LicenseManager.getProduct(this.productIdentifier.getStringValue());
            product.parseLicense(licenseKey);
            if (setLicense) {
                product.setLicense(licenseKey);
            }
        }
        catch (LicenseException e) {
            throw new InvalidSettingsException(e.getMessage());
        }
    }

    void saveSettings(NodeSettingsWO settings) {
        this.productIdentifier.saveSettingsTo(settings);
        this.licenseKey.saveSettingsTo(settings);
    }

    void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.productIdentifier.validateSettings(settings);
        this.licenseKey.validateSettings(settings);
    }

    void loadSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.productIdentifier.loadSettingsFrom(settings);
        this.licenseKey.loadSettingsFrom(settings);
    }
}

