/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.hackernews.v0.timeout;

import com.nodepit.nodes.hackernews.v0.InterceptorFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.knime.core.node.NodeLogger;

public class TimeoutInterceptorFactory
extends InterceptorFactory<TimeoutData> {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(TimeoutInterceptorFactory.class);
    public static final String IDENTIFIER = "timeout";

    public TimeoutInterceptorFactory() {
        super(IDENTIFIER, TimeoutData.class);
    }

    @Override
    protected Interceptor createInterceptor(final TimeoutData data) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                LOGGER.debugWithFormat("Timeout in seconds: connect=%s, read=%s, write=%s", new Object[]{data.connectTimeout, data.readTimeout, data.writeTimeout});
                return chain.withConnectTimeout(data.connectTimeout, TimeUnit.SECONDS).withReadTimeout(data.readTimeout, TimeUnit.SECONDS).withWriteTimeout(data.writeTimeout, TimeUnit.SECONDS).proceed(chain.request());
            }
        };
    }

    public static final class TimeoutData {
        int connectTimeout;
        int readTimeout;
        int writeTimeout;
    }
}

