/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.hackernews.v0.operation.getuser;

import com.nodepit.nodes.hackernews.v0.HttpRequestNodeParameters;
import com.nodepit.nodes.hackernews.v0.NodeParametersUtils;
import com.nodepit.nodes.hackernews.v0.ResponseMapper;
import com.nodepit.nodes.hackernews.v0.SimpleResponseMapper;
import com.nodepit.nodes.hackernews.v0.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetUserNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="ID", description="The user's unique username. Case-sensitive.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>ID:</b> The user's unique username. Case-sensitive.</li>\n\t<li><b>Created:</b> Creation date of the user, in Unix Time.</li>\n\t<li><b>Karma:</b> The user's karma.</li>\n\t<li><b>About:</b> The user's optional self-description. HTML.</li>\n\t<li><b>Submitted:</b> List of the user's stories, polls and comments.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetUserNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"created\":\"rows[0][1]\",\"karma\":\"rows[0][2]\",\"about\":\"rows[0][3]\",\"submitted\":\"rows[0][4]\"}}]").addBodyColumn(new DataColumnSpecCreator("ID", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Created", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Karma", LongCell.LongCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("About", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Submitted", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetUserNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cID\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetUserNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetUserNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

