/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.hackernews.v0;

import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.LicenseManager;
import com.nodepit.nodes.hackernews.v0.Utils;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import org.knime.core.node.NodeLogger;
import org.knime.core.util.EclipseUtil;

public class LicenseChecker {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LicenseChecker.class);
    public static final String PRODUCT_ID = "com.nodepit.nodes.hackernews.v0.product";
    private static final byte[] DIGEST = new byte[]{13, 78, 68, 83, -118, 123, 115, 122, -39, -19, 38, -72, -41, -110, -22, 78, 113, -110, 95, 123, -14, -62, -53, -114, 17, -74, -125, 48, -18, -53, -127, 60, 2, 55, 5, 8, 59, -72, 91, -98, -29, -123, -73, 88, -36, 30, 38, 116, -55, -48, 6, 123, 127, 33, 46, -46, -41, -121, -66, 127, -25, 121, 19, -3};
    private static final String LICENSE_NODE_MESSAGE = new StringJoiner(" ").add("Using Hacker News Nodes on a KNIME Server or Hub requires a valid license.").add("Please obtain a license on the vendor's website and enter it on the extension's preference page.").add("In case of questions, please contact mail@nodepit.com.").toString();
    private static final String LICENSE_LOG_MESSAGE = new StringJoiner("\n").add("\n").add("*".repeat(80)).add(Utils.wrap(LICENSE_NODE_MESSAGE, 80, "  ")).add("*".repeat(80)).add("\n").toString();

    public static void checkLicense() {
        if (EclipseUtil.determineServerUsage() || LicenseChecker.isRunningOnKNIMEServer()) {
            try {
                LicenseManager.getProduct((String)PRODUCT_ID).getLicense();
            }
            catch (LicenseException licenseException) {
                LOGGER.error((Object)LICENSE_LOG_MESSAGE);
                throw new IllegalStateException(LICENSE_NODE_MESSAGE);
            }
        }
    }

    private static boolean isRunningOnKNIMEServer() {
        String enterpriseApplicationClass = "com.knime.enterprise.executor.KNIMEExecutorApplication";
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        Iterator<StackTraceElement[]> iterator = stackTraces.values().iterator();
        while (iterator.hasNext()) {
            StackTraceElement[] stackTraceElements;
            StackTraceElement[] stackTraceElementArray = stackTraceElements = iterator.next();
            int n = stackTraceElements.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (stackTraceElement.getClassName().startsWith(enterpriseApplicationClass)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private LicenseChecker() {
    }

    public static final class Helper
    implements LicenseHelper {
        public byte[] getDigest() {
            return DIGEST;
        }
    }
}

