/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.hackernews.v0.operation.getitem;

import com.nodepit.nodes.hackernews.v0.HttpRequestNodeParameters;
import com.nodepit.nodes.hackernews.v0.NodeParametersUtils;
import com.nodepit.nodes.hackernews.v0.ResponseMapper;
import com.nodepit.nodes.hackernews.v0.SimpleResponseMapper;
import com.nodepit.nodes.hackernews.v0.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class GetItemNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="ID", description="The item's unique identifier.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @NumberInputWidget
    int id = 0;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>ID:</b> The item's unique identifier.</li>\n\t<li><b>Deleted:</b> <tt>true</tt> if the item is deleted.</li>\n\t<li><b>Type:</b> The type of item. One of &quot;job&quot;, &quot;story&quot;, &quot;comment&quot;, &quot;poll&quot;, or &quot;pollopt&quot;.</li>\n\t<li><b>By:</b> The username of the item's author.</li>\n\t<li><b>Time:</b> Creation date of the item, in Unix Time.</li>\n\t<li><b>Text:</b> The comment, story or poll text. HTML.</li>\n\t<li><b>Dead:</b> <tt>true</tt> if the item is dead.</li>\n\t<li><b>Parent:</b> The comment's parent: either another comment or the relevant story.</li>\n\t<li><b>Poll:</b> The pollopt's associated poll.</li>\n\t<li><b>Kids:</b> The identifiers of the item's comments, in ranked display order.</li>\n\t<li><b>Url:</b> The URL of the story.</li>\n\t<li><b>Score:</b> The story's score, or the votes for a pollopt.</li>\n\t<li><b>Title:</b> The title of the story, poll or job. HTML.</li>\n\t<li><b>Parts:</b> A list of related pollopts, in display order.</li>\n\t<li><b>Descendants:</b> In the case of stories or polls, the total comment count.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetItemNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"id\":\"rows[0][0]\",\"deleted\":\"rows[0][1]\",\"type\":\"rows[0][2]\",\"by\":\"rows[0][3]\",\"time\":\"rows[0][4]\",\"text\":\"rows[0][5]\",\"dead\":\"rows[0][6]\",\"parent\":\"rows[0][7]\",\"poll\":\"rows[0][8]\",\"kids\":\"rows[0][9]\",\"url\":\"rows[0][10]\",\"score\":\"rows[0][11]\",\"title\":\"rows[0][12]\",\"parts\":\"rows[0][13]\",\"descendants\":\"rows[0][14]\"}}]").addBodyColumn(new DataColumnSpecCreator("ID", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Deleted", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("By", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Time", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Text", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Dead", BooleanCell.BooleanCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Parent", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Poll", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Kids", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Url", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Score", IntCell.IntCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Title", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Parts", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Descendants", IntCell.IntCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetItemNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class GetItemNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetItemNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

