/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.licensing;

import com.nodepit.licensing.LicensableProduct;
import com.nodepit.licensing.LicenseException;
import com.nodepit.licensing.LicenseHelper;
import com.nodepit.licensing.LicenseInformation;
import com.nodepit.licensing.internal.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.knime.core.node.NodeLogger;
import org.osgi.framework.Bundle;

public final class LicenseManager {
    private static final NodeLogger LOGGER = NodeLogger.getLogger(LicenseManager.class);
    private static final String EXTENSION_POINT_ID = "com.nodepit.licensing.plugin.LicensableProduct";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_PUBLIC_KEY_PATH = "publicKeyPath";
    private static final String ATTRIBUTE_LICENSE_HELPER = "licenseHelper";
    private static final String ATTRIBUTE_ICON_16 = "icon16";
    private static final Map<String, LicensableProduct> LICENSABLE_PRODUCTS = LicenseManager.loadLicensableProducts();

    static {
        LicenseManager.plausibilityCheck();
    }

    public static LicensableProduct getProduct(String productIdentifier) {
        LicensableProduct product = LICENSABLE_PRODUCTS.get(productIdentifier);
        if (product == null) {
            throw new IllegalArgumentException(String.format("Unknown product identifier '%s'", productIdentifier));
        }
        return product;
    }

    public static Collection<LicensableProduct> getProducts() {
        return LICENSABLE_PRODUCTS.values();
    }

    static Collection<LicenseInformation> getLicenses() throws LicenseException {
        ArrayList<LicenseInformation> licenseInfos = new ArrayList<LicenseInformation>();
        for (LicensableProduct product : LicenseManager.getProducts()) {
            try {
                licenseInfos.add(product.getLicense());
            }
            catch (Exception exception) {}
        }
        return Collections.unmodifiableCollection(licenseInfos);
    }

    private static Map<String, LicensableProduct> loadLicensableProducts() {
        HashMap<String, LicensableProduct> result = new HashMap<String, LicensableProduct>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension for 'com.nodepit.licensing.plugin.LicensableProduct'.");
        }
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            LicensableProduct licensableProduct = LicenseManager.parseLicensableProduct(element);
            if (licensableProduct != null) {
                result.put(licensableProduct.id, licensableProduct);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(result);
    }

    private static LicensableProduct parseLicensableProduct(IConfigurationElement productExtension) {
        Bundle bundle;
        URL[] entries;
        LicenseHelper licenseHelper;
        String publicKeyPath;
        String id;
        block8: {
            id = productExtension.getAttribute(ATTRIBUTE_ID);
            if (id == null) {
                LOGGER.errorWithFormat("Extension is missing attribute '%s'", new Object[]{ATTRIBUTE_ID});
                return null;
            }
            publicKeyPath = productExtension.getAttribute(ATTRIBUTE_PUBLIC_KEY_PATH);
            if (publicKeyPath == null) {
                LOGGER.errorWithFormat("Extension is missing attribute '%s'", new Object[]{ATTRIBUTE_PUBLIC_KEY_PATH});
                return null;
            }
            licenseHelper = LicenseHelper.DEFAULT;
            if (productExtension.getAttribute(ATTRIBUTE_LICENSE_HELPER) != null) {
                try {
                    Object licenseHelperInstance = productExtension.createExecutableExtension(ATTRIBUTE_LICENSE_HELPER);
                    if (licenseHelperInstance instanceof LicenseHelper) {
                        licenseHelper = (LicenseHelper)licenseHelperInstance;
                        break block8;
                    }
                    LOGGER.errorWithFormat("Instance for attribute '%s' does not implement %s", new Object[]{ATTRIBUTE_LICENSE_HELPER, LicenseHelper.class.getName()});
                    return null;
                }
                catch (CoreException coreException) {
                    LOGGER.errorWithFormat("Could not create instance for attribute '%s'", new Object[]{ATTRIBUTE_LICENSE_HELPER});
                    return null;
                }
            }
        }
        ImageIcon icon = null;
        String icon16pxAttrValue = productExtension.getAttribute(ATTRIBUTE_ICON_16);
        if (icon16pxAttrValue != null && (entries = FileLocator.findEntries((Bundle)(bundle = Platform.getBundle((String)productExtension.getNamespaceIdentifier())), (IPath)new Path(icon16pxAttrValue))).length == 1) {
            icon = new ImageIcon(entries[0]);
        }
        if ((entries = FileLocator.findEntries((Bundle)(bundle = Platform.getBundle((String)productExtension.getNamespaceIdentifier())), (IPath)new Path(publicKeyPath))).length == 0) {
            LOGGER.errorWithFormat("File '%s' not found", new Object[]{publicKeyPath});
            return null;
        }
        return new LicensableProduct(id, entries[0], bundle, licenseHelper, icon);
    }

    private static void plausibilityCheck() {
        Date today = Utils.getToday();
        Date buildDate = Utils.parseDate("2025-02-13T07:32:47Z".replaceAll("T.*", ""));
        if (buildDate.after(today)) {
            throw new IllegalStateException("Invalid system date.");
        }
    }

    private LicenseManager() {
    }
}

