/*
 * Decompiled with CFR 0.152.
 */
package com.verhas.licensor;

import java.io.OutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;

class PaddingJcaPGPContentVerifierBuilderProvider
extends JcaPGPContentVerifierBuilderProvider {
    PaddingJcaPGPContentVerifierBuilderProvider() {
    }

    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        final PGPContentVerifierBuilder builder = super.get(keyAlgorithm, hashAlgorithm);
        return new PGPContentVerifierBuilder(){

            public PGPContentVerifier build(PGPPublicKey publicKey) throws PGPException {
                switch (publicKey.getAlgorithm()) {
                    case 1: 
                    case 2: {
                        return new PGPContentVerifierProxy(builder.build(publicKey), publicKey.getBitStrength() / 8);
                    }
                }
                return builder.build(publicKey);
            }
        };
    }

    private static class PGPContentVerifierProxy
    implements PGPContentVerifier {
        final PGPContentVerifier delegate;
        final int padSize;

        PGPContentVerifierProxy(PGPContentVerifier delegate, int padSize) {
            this.delegate = delegate;
            this.padSize = padSize;
        }

        public OutputStream getOutputStream() {
            return this.delegate.getOutputStream();
        }

        public int getHashAlgorithm() {
            return this.delegate.getHashAlgorithm();
        }

        public int getKeyAlgorithm() {
            return this.delegate.getKeyAlgorithm();
        }

        public long getKeyID() {
            return this.delegate.getKeyID();
        }

        public boolean verify(byte[] expected) {
            byte[] padded = new byte[this.padSize];
            System.arraycopy(expected, 0, padded, this.padSize - expected.length, expected.length);
            return this.delegate.verify(padded);
        }
    }
}

