/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3.operation.searchandreconsileissuesusingjql;

import com.nodepit.nodes.jira.v3.HttpRequestNodeParameters;
import com.nodepit.nodes.jira.v3.NodeParametersUtils;
import com.nodepit.nodes.jira.v3.ResponseMapper;
import com.nodepit.nodes.jira.v3.SimpleResponseMapper;
import com.nodepit.nodes.jira.v3.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class SearchAndReconsileIssuesUsingJqlNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set JQL", description="Enable to set the optional field <b>JQL</b>")
    @ValueReference(value=JqlEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean jqlEnabled = false;
    @Widget(title="JQL", description="\t<p>A <a href=\"https://confluence.atlassian.com/x/egORLQ\">JQL</a> expression. For performance reasons, this parameter requires a bounded query. A bounded query is a query with a search restriction.</p>\n<ul>\n<li>Example of an unbounded query: <tt>order by key desc</tt>.</li>\n<li>Example of a bounded query: <tt>assignee = currentUser() order by key</tt>.</li>\n</ul>\n<p>Additionally, <tt>orderBy</tt> clause can contain a maximum of 7 fields.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=JqlEnabledRef.class, type=Effect.EffectType.SHOW)
    String jql = null;
    @Widget(title="Set Next Page Token", description="Enable to set the optional field <b>Next Page Token</b>")
    @ValueReference(value=NextPageTokenEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean nextPageTokenEnabled = false;
    @Widget(title="Next Page Token", description="\t<p>The token for a page to fetch that is not the first page. The first page has a <tt>nextPageToken</tt> of <tt>null</tt>. Use the <tt>nextPageToken</tt> to fetch the next page of issues.</p>\n<p>Note: The <tt>nextPageToken</tt> field is <b>not included</b> in the response for the last page, indicating there is no next page.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=NextPageTokenEnabledRef.class, type=Effect.EffectType.SHOW)
    String nextPageToken = null;
    @Widget(title="Set Max Results", description="Enable to set the optional field <b>Max Results</b>")
    @ValueReference(value=MaxResultsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean maxResultsEnabled = false;
    @Widget(title="Max Results", description="The maximum number of items to return per page. To manage page size, API may return fewer items per page where a large number of fields or properties are requested. The greatest number of items returned per page is achieved when requesting <tt>id</tt> or <tt>key</tt> only. It returns max 5000 issues.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=MaxResultsEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int maxResults = 50;
    @Widget(title="Set Fields", description="Enable to set the optional field <b>Fields</b>")
    @ValueReference(value=FieldsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsEnabled = false;
    @Widget(title="Fields", description="\t<p>A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:</p>\n<ul>\n<li><tt>*all</tt> Returns all fields.</li>\n<li><tt>*navigable</tt> Returns navigable fields.</li>\n<li><tt>id</tt> Returns only issue IDs.</li>\n<li>Any issue field, prefixed with a minus to exclude.</li>\n</ul>\n<p>The default is <tt>id</tt>.</p>\n<p>Examples:</p>\n<ul>\n<li><tt>summary,comment</tt> Returns only the summary and comments fields only.</li>\n<li><tt>-description</tt> Returns all navigable (default) fields except description.</li>\n<li><tt>*all,-comment</tt> Returns all fields except comments.</li>\n</ul>\n<p>Multiple <tt>fields</tt> parameters can be included in a request.</p>\n<p>Note: By default, this resource returns IDs only. This differs from <a href=\"#api-rest-api-3-issue-issueIdOrKey-get\">GET issue</a> where the default is all fields.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=FieldsPersistor.class)
    Fields[] fields = new Fields[]{new Fields(null)};
    @Widget(title="Set Expand", description="Enable to set the optional field <b>Expand</b>")
    @ValueReference(value=ExpandEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean expandEnabled = false;
    @Widget(title="Expand", description="\t<p>Use <a href=\"#expansion\">expand</a> to include additional information about issues in the response. Note that, unlike the majority of instances where <tt>expand</tt> is specified, <tt>expand</tt> is defined as a comma-delimited string of values. The expand options are:</p>\n<ul>\n<li><tt>renderedFields</tt> Returns field values rendered in HTML format.</li>\n<li><tt>names</tt> Returns the display name of each field.</li>\n<li><tt>schema</tt> Returns the schema describing a field type.</li>\n<li><tt>transitions</tt> Returns all possible transitions for the issue.</li>\n<li><tt>operations</tt> Returns all possible operations for the issue.</li>\n<li><tt>editmeta</tt> Returns information about how each field can be edited.</li>\n<li><tt>changelog</tt> Returns a list of recent updates to an issue, sorted by date, starting from the most recent.</li>\n<li><tt>versionedRepresentations</tt> Instead of <tt>fields</tt>, returns <tt>versionedRepresentations</tt> a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.</li>\n</ul>\n<p>Examples: <tt>&quot;names,changelog&quot;</tt> Returns the display name of each field as well as a list of recent updates to an issue.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExpandEnabledRef.class, type=Effect.EffectType.SHOW)
    String expand = null;
    @Widget(title="Set Properties", description="Enable to set the optional field <b>Properties</b>")
    @ValueReference(value=PropertiesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean propertiesEnabled = false;
    @Widget(title="Properties", description="A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PropertiesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=PropertiesPersistor.class)
    Properties[] properties = new Properties[]{new Properties(null)};
    @Widget(title="Set Fields by Keys", description="Enable to set the optional field <b>Fields by Keys</b>")
    @ValueReference(value=FieldsByKeysEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsByKeysEnabled = false;
    @Widget(title="Fields by Keys", description="Reference fields by their key (rather than ID). The default is <tt>false</tt>.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsByKeysEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fields_By_KeysPersistor.class)
    String fieldsByKeys = "false";
    @Widget(title="Set Fail Fast", description="Enable to set the optional field <b>Fail Fast</b>")
    @ValueReference(value=FailFastEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean failFastEnabled = false;
    @Widget(title="Fail Fast", description="Fail this request early if we can't retrieve all field data.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FailFastEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fail_FastPersistor.class)
    String failFast = "false";
    @Widget(title="Set Reconcile Issues", description="Enable to set the optional field <b>Reconcile Issues</b>")
    @ValueReference(value=ReconcileIssuesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean reconcileIssuesEnabled = false;
    @Widget(title="Reconcile Issues", description="Strong consistency issue ids to be reconciled with search results. Accepts max 50 ids\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ReconcileIssuesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Reconcile_IssuesPersistor.class)
    Reconcile_Issues[] reconcileIssues = new Reconcile_Issues[]{new Reconcile_Issues(null)};
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Changelog:</b> Details of changelogs associated with the issue.</li>\n\t<li><b>Editmeta:</b> The metadata for the fields on the issue that can be amended.</li>\n\t<li><b>Expand:</b> Expand options that include additional issue details in the response.</li>\n\t<li><b>Fields:</b> </li>\n\t<li><b>Fields to Include:</b> </li>\n\t<li><b>Id:</b> The ID of the issue.</li>\n\t<li><b>Key:</b> The key of the issue.</li>\n\t<li><b>Names:</b> The ID and name of each field present on the issue.</li>\n\t<li><b>Operations:</b> The operations that can be performed on the issue.</li>\n\t<li><b>Properties:</b> Details of the issue properties identified in the request.</li>\n\t<li><b>Rendered Fields:</b> The rendered value of each field present on the issue.</li>\n\t<li><b>Schema:</b> The schema describing each field present on the issue.</li>\n\t<li><b>Self:</b> The URL of the issue details.</li>\n\t<li><b>Transitions:</b> The transitions that can be performed on the issue.</li>\n\t<li><b>Versioned Representations:</b> The versions of each field on the issue.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=SearchAndReconsileIssuesUsingJqlNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"issues\":{\"*\":{\"changelog\":\"rows[#2][0]\",\"editmeta\":\"rows[#2][1]\",\"expand\":\"rows[#2][2]\",\"fields\":\"rows[#2][3]\",\"fieldsToInclude\":\"rows[#2][4]\",\"id\":\"rows[#2][5]\",\"key\":\"rows[#2][6]\",\"names\":\"rows[#2][7]\",\"operations\":\"rows[#2][8]\",\"properties\":\"rows[#2][9]\",\"renderedFields\":\"rows[#2][10]\",\"schema\":\"rows[#2][11]\",\"self\":\"rows[#2][12]\",\"transitions\":\"rows[#2][13]\",\"versionedRepresentations\":\"rows[#2][14]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Changelog", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Editmeta", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expand", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields to Include", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Key", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Names", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Operations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Properties", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rendered Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Schema", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Self", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transitions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Versioned Representations", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    SearchAndReconsileIssuesUsingJqlNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.jqlEnabled) {
            params.add(new HttpRequestNodeParameters.Param("jql", this.jql));
        }
        if (this.nextPageTokenEnabled) {
            params.add(new HttpRequestNodeParameters.Param("nextPageToken", this.nextPageToken));
        }
        if (this.maxResultsEnabled) {
            params.add(new HttpRequestNodeParameters.Param("maxResults", this.maxResults));
        }
        if (this.fieldsEnabled) {
            Arrays.stream(this.fields).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields", value.text));
            });
        }
        if (this.expandEnabled) {
            params.add(new HttpRequestNodeParameters.Param("expand", this.expand));
        }
        if (this.propertiesEnabled) {
            Arrays.stream(this.properties).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("properties", value.text));
            });
        }
        if (this.fieldsByKeysEnabled) {
            params.add(new HttpRequestNodeParameters.Param("fieldsByKeys", this.fieldsByKeys));
        }
        if (this.failFastEnabled) {
            params.add(new HttpRequestNodeParameters.Param("failFast", this.failFast));
        }
        if (this.reconcileIssuesEnabled) {
            Arrays.stream(this.reconcileIssues).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("reconcileIssues", value.text));
            });
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ExpandEnabledRef
    implements BooleanReference {
        private ExpandEnabledRef() {
        }
    }

    private static final class FailFastEnabledRef
    implements BooleanReference {
        private FailFastEnabledRef() {
        }
    }

    private static final class Fail_FastPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "failFast";

        private Fail_FastPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    static final class Fields
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Fields() {
        }

        Fields(String text) {
            this.text = text;
        }
    }

    private static final class FieldsByKeysEnabledRef
    implements BooleanReference {
        private FieldsByKeysEnabledRef() {
        }
    }

    private static final class FieldsEnabledRef
    implements BooleanReference {
        private FieldsEnabledRef() {
        }
    }

    private static final class FieldsPersistor
    implements NodeParametersPersistor<Fields[]> {
        static final String CONFIG_KEY = "fields";

        private FieldsPersistor() {
        }

        public Fields[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields::new).toArray(Fields[]::new);
        }

        public void save(Fields[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Fields_By_KeysPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "fieldsByKeys";

        private Fields_By_KeysPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class JqlEnabledRef
    implements BooleanReference {
        private JqlEnabledRef() {
        }
    }

    private static final class MaxResultsEnabledRef
    implements BooleanReference {
        private MaxResultsEnabledRef() {
        }
    }

    private static final class NextPageTokenEnabledRef
    implements BooleanReference {
        private NextPageTokenEnabledRef() {
        }
    }

    static final class Properties
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Properties() {
        }

        Properties(String text) {
            this.text = text;
        }
    }

    private static final class PropertiesEnabledRef
    implements BooleanReference {
        private PropertiesEnabledRef() {
        }
    }

    private static final class PropertiesPersistor
    implements NodeParametersPersistor<Properties[]> {
        static final String CONFIG_KEY = "properties";

        private PropertiesPersistor() {
        }

        public Properties[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Properties[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Properties::new).toArray(Properties[]::new);
        }

        public void save(Properties[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class ReconcileIssuesEnabledRef
    implements BooleanReference {
        private ReconcileIssuesEnabledRef() {
        }
    }

    static final class Reconcile_Issues
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Reconcile_Issues() {
        }

        Reconcile_Issues(String text) {
            this.text = text;
        }
    }

    private static final class Reconcile_IssuesPersistor
    implements NodeParametersPersistor<Reconcile_Issues[]> {
        static final String CONFIG_KEY = "reconcileIssues";

        private Reconcile_IssuesPersistor() {
        }

        public Reconcile_Issues[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Reconcile_Issues[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Reconcile_Issues::new).toArray(Reconcile_Issues[]::new);
        }

        public void save(Reconcile_Issues[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class SearchAndReconsileIssuesUsingJqlNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private SearchAndReconsileIssuesUsingJqlNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

