/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.nodepit.nodes.jira.v3.port.ConfigPortObjectSpec;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public abstract class InterceptorFactory<ConfigData> {
    private static final String INTERCEPTOR_EXTENSION_POINT_ID = "com.nodepit.nodes.jira.v3.plugin.interceptors";
    private static final String INTERCEPTOR_FACTORY_CLASS_ATTRIBUTE = "factoryClass";
    private final String identifier;
    private final Class<ConfigData> configDataType;

    protected InterceptorFactory(String identifier, Class<ConfigData> configDataType) {
        this.identifier = Objects.requireNonNull(identifier, "identifier was null");
        this.configDataType = Objects.requireNonNull(configDataType, "configDataType was null");
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    protected abstract Interceptor createInterceptor(ConfigData var1);

    public void applyAdditionalConfig(OkHttpClient.Builder builder) {
    }

    public final Interceptor createInterceptorCast(Object interceptorConfig) {
        return this.createInterceptor(this.configDataType.cast(interceptorConfig));
    }

    public final ConfigPortObjectSpec.InterceptorConfig parseConfig(JsonElement json) {
        Object config = new Gson().fromJson(json, this.configDataType);
        return new ConfigPortObjectSpec.InterceptorConfig(this.getIdentifier(), config);
    }

    public static InterceptorFactory<?> create(String identifier) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(INTERCEPTOR_EXTENSION_POINT_ID);
        if (point == null) {
            throw new IllegalStateException("No extension for 'com.nodepit.nodes.jira.v3.plugin.interceptors'.");
        }
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String constructorClassName = element.getAttribute(INTERCEPTOR_FACTORY_CLASS_ATTRIBUTE);
            if (constructorClassName == null || constructorClassName.isEmpty()) {
                throw new IllegalStateException("Extension is missing attribute 'factoryClass'.");
            }
            try {
                InterceptorFactory instance = (InterceptorFactory)element.createExecutableExtension(INTERCEPTOR_FACTORY_CLASS_ATTRIBUTE);
                if (instance.getIdentifier().equals(identifier)) {
                    return instance;
                }
            }
            catch (CoreException e) {
                throw new IllegalStateException("Could not instantiate '" + constructorClassName + "'.", e);
            }
            ++n2;
        }
        throw new IllegalArgumentException("No interceptor for " + identifier);
    }
}

