/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3.operation.getissue;

import com.nodepit.nodes.jira.v3.HttpRequestNodeModel;
import com.nodepit.nodes.jira.v3.operation.getissue.GetIssueNodeParameters;
import com.nodepit.nodes.jira.v3.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public class GetIssueNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Get Issue").icon("../../node.png").shortDescription("Get issue").fullDescription("\t\t\t<p>Returns the details for an issue.</p>\n<p>The issue is identified by its ID or key, however, if the identifier doesn't match an issue, a case-insensitive search and check for moved issues is performed. If a matching issue is found its details are returned, a 302 or other redirect is <b>not</b> returned. The issue key returned in the response is the key of the issue found.</p>\n<p>This operation can be accessed anonymously.</p>\n<p><b><a href=\"#permissions\">Permissions</a> required:</b></p>\n<ul>\n<li><i>Browse projects</i> <a href=\"https://confluence.atlassian.com/x/yodKLg\">project permission</a> for the project that the issue is in.</li>\n<li>If <a href=\"https://confluence.atlassian.com/x/J4lKLg\">issue-level security</a> is configured, issue-level security permission to view the issue.</li>\n</ul>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(GetIssueNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel.buildExecute("GET", "/rest/api/3/issue/{issueIdOrKey}"))).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"getIssue", "GET /rest/api/3/issue/{issueIdOrKey}"});

    public GetIssueNodeFactory() {
        super(NODE);
    }
}

