/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3.operation.getissue;

import com.nodepit.nodes.jira.v3.HttpRequestNodeParameters;
import com.nodepit.nodes.jira.v3.NodeParametersUtils;
import com.nodepit.nodes.jira.v3.ResponseMapper;
import com.nodepit.nodes.jira.v3.SimpleResponseMapper;
import com.nodepit.nodes.jira.v3.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetIssueNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Issue ID or Key", description="The ID or key of the issue.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String issueIdOrKey = null;
    @Widget(title="Set Fields", description="Enable to set the optional field <b>Fields</b>")
    @ValueReference(value=FieldsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsEnabled = false;
    @Widget(title="Fields", description="\t<p>A list of fields to return for the issue. This parameter accepts a comma-separated list. Use it to retrieve a subset of fields. Allowed values:</p>\n<ul>\n<li><tt>*all</tt> Returns all fields.</li>\n<li><tt>*navigable</tt> Returns navigable fields.</li>\n<li>Any issue field, prefixed with a minus to exclude.</li>\n</ul>\n<p>Examples:</p>\n<ul>\n<li><tt>summary,comment</tt> Returns only the summary and comments fields.</li>\n<li><tt>-description</tt> Returns all (default) fields except description.</li>\n<li><tt>*navigable,-comment</tt> Returns all navigable fields except comment.</li>\n</ul>\n<p>This parameter may be specified multiple times. For example, <tt>fields=field1,field2&amp; fields=field3</tt>.</p>\n<p>Note: All fields are returned by default. This differs from <a href=\"#api-rest-api-3-search-get\">Search for issues using JQL (GET)</a> and <a href=\"#api-rest-api-3-search-post\">Search for issues using JQL (POST)</a> where the default is all navigable fields.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=FieldsPersistor.class)
    Fields[] fields = new Fields[]{new Fields(null)};
    @Widget(title="Set Fields by Keys", description="Enable to set the optional field <b>Fields by Keys</b>")
    @ValueReference(value=FieldsByKeysEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsByKeysEnabled = false;
    @Widget(title="Fields by Keys", description="Whether fields in <tt>fields</tt> are referenced by keys rather than IDs. This parameter is useful where fields have been added by a connect app and a field's key may differ from its ID.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsByKeysEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fields_By_KeysPersistor.class)
    String fieldsByKeys = "false";
    @Widget(title="Set Expand", description="Enable to set the optional field <b>Expand</b>")
    @ValueReference(value=ExpandEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean expandEnabled = false;
    @Widget(title="Expand", description="\t<p>Use <a href=\"#expansion\">expand</a> to include additional information about the issues in the response. This parameter accepts a comma-separated list. Expand options include:</p>\n<ul>\n<li><tt>renderedFields</tt> Returns field values rendered in HTML format.</li>\n<li><tt>names</tt> Returns the display name of each field.</li>\n<li><tt>schema</tt> Returns the schema describing a field type.</li>\n<li><tt>transitions</tt> Returns all possible transitions for the issue.</li>\n<li><tt>editmeta</tt> Returns information about how each field can be edited.</li>\n<li><tt>changelog</tt> Returns a list of recent updates to an issue, sorted by date, starting from the most recent.</li>\n<li><tt>versionedRepresentations</tt> Returns a JSON array for each version of a field's value, with the highest number representing the most recent version. Note: When included in the request, the <tt>fields</tt> parameter is ignored.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExpandEnabledRef.class, type=Effect.EffectType.SHOW)
    String expand = null;
    @Widget(title="Set Properties", description="Enable to set the optional field <b>Properties</b>")
    @ValueReference(value=PropertiesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean propertiesEnabled = false;
    @Widget(title="Properties", description="\t<p>A list of issue properties to return for the issue. This parameter accepts a comma-separated list. Allowed values:</p>\n<ul>\n<li><tt>*all</tt> Returns all issue properties.</li>\n<li>Any issue property key, prefixed with a minus to exclude.</li>\n</ul>\n<p>Examples:</p>\n<ul>\n<li><tt>*all</tt> Returns all properties.</li>\n<li><tt>*all,-prop1</tt> Returns all properties except <tt>prop1</tt>.</li>\n<li><tt>prop1,prop2</tt> Returns <tt>prop1</tt> and <tt>prop2</tt> properties.</li>\n</ul>\n<p>This parameter may be specified multiple times. For example, <tt>properties=prop1,prop2&amp; properties=prop3</tt>.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PropertiesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=PropertiesPersistor.class)
    Properties[] properties = new Properties[]{new Properties(null)};
    @Widget(title="Set Update History", description="Enable to set the optional field <b>Update History</b>")
    @ValueReference(value=UpdateHistoryEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean updateHistoryEnabled = false;
    @Widget(title="Update History", description="Whether the project in which the issue is created is added to the user's <b>Recently viewed</b> project list, as shown under <b>Projects</b> in Jira. This also populates the <a href=\"#api-rest-api-3-search-get\">JQL issues search</a> <tt>lastViewed</tt> field.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=UpdateHistoryEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Update_HistoryPersistor.class)
    String updateHistory = "false";
    @Widget(title="Set Fail Fast", description="Enable to set the optional field <b>Fail Fast</b>")
    @ValueReference(value=FailFastEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean failFastEnabled = false;
    @Widget(title="Fail Fast", description="Whether to fail the request quickly in case of an error while loading fields for an issue. For <tt>failFast=true</tt>, if one field fails, the entire operation fails. For <tt>failFast=false</tt>, the operation will continue even if a field fails. It will return a valid response, but without values for the failed field(s).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FailFastEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fail_FastPersistor.class)
    String failFast = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Changelog:</b> Details of changelogs associated with the issue.</li>\n\t<li><b>Editmeta:</b> The metadata for the fields on the issue that can be amended.</li>\n\t<li><b>Expand:</b> Expand options that include additional issue details in the response.</li>\n\t<li><b>Fields:</b> </li>\n\t<li><b>Fields to Include:</b> </li>\n\t<li><b>Id:</b> The ID of the issue.</li>\n\t<li><b>Key:</b> The key of the issue.</li>\n\t<li><b>Names:</b> The ID and name of each field present on the issue.</li>\n\t<li><b>Operations:</b> The operations that can be performed on the issue.</li>\n\t<li><b>Properties:</b> Details of the issue properties identified in the request.</li>\n\t<li><b>Rendered Fields:</b> The rendered value of each field present on the issue.</li>\n\t<li><b>Schema:</b> The schema describing each field present on the issue.</li>\n\t<li><b>Self:</b> The URL of the issue details.</li>\n\t<li><b>Transitions:</b> The transitions that can be performed on the issue.</li>\n\t<li><b>Versioned Representations:</b> The versions of each field on the issue.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetIssueNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"changelog\":\"rows[0][0]\",\"editmeta\":\"rows[0][1]\",\"expand\":\"rows[0][2]\",\"fields\":\"rows[0][3]\",\"fieldsToInclude\":\"rows[0][4]\",\"id\":\"rows[0][5]\",\"key\":\"rows[0][6]\",\"names\":\"rows[0][7]\",\"operations\":\"rows[0][8]\",\"properties\":\"rows[0][9]\",\"renderedFields\":\"rows[0][10]\",\"schema\":\"rows[0][11]\",\"self\":\"rows[0][12]\",\"transitions\":\"rows[0][13]\",\"versionedRepresentations\":\"rows[0][14]\"}}]").addBodyColumn(new DataColumnSpecCreator("Changelog", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Editmeta", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expand", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields to Include", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Key", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Names", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Operations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Properties", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rendered Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Schema", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Self", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transitions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Versioned Representations", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetIssueNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.issueIdOrKey == null || this.issueIdOrKey.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cIssue ID or Key\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("issueIdOrKey", this.issueIdOrKey));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsEnabled) {
            Arrays.stream(this.fields).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields", value.text));
            });
        }
        if (this.fieldsByKeysEnabled) {
            params.add(new HttpRequestNodeParameters.Param("fieldsByKeys", this.fieldsByKeys));
        }
        if (this.expandEnabled) {
            params.add(new HttpRequestNodeParameters.Param("expand", this.expand));
        }
        if (this.propertiesEnabled) {
            Arrays.stream(this.properties).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("properties", value.text));
            });
        }
        if (this.updateHistoryEnabled) {
            params.add(new HttpRequestNodeParameters.Param("updateHistory", this.updateHistory));
        }
        if (this.failFastEnabled) {
            params.add(new HttpRequestNodeParameters.Param("failFast", this.failFast));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ExpandEnabledRef
    implements BooleanReference {
        private ExpandEnabledRef() {
        }
    }

    private static final class FailFastEnabledRef
    implements BooleanReference {
        private FailFastEnabledRef() {
        }
    }

    private static final class Fail_FastPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "failFast";

        private Fail_FastPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    static final class Fields
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Fields() {
        }

        Fields(String text) {
            this.text = text;
        }
    }

    private static final class FieldsByKeysEnabledRef
    implements BooleanReference {
        private FieldsByKeysEnabledRef() {
        }
    }

    private static final class FieldsEnabledRef
    implements BooleanReference {
        private FieldsEnabledRef() {
        }
    }

    private static final class FieldsPersistor
    implements NodeParametersPersistor<Fields[]> {
        static final String CONFIG_KEY = "fields";

        private FieldsPersistor() {
        }

        public Fields[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields::new).toArray(Fields[]::new);
        }

        public void save(Fields[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Fields_By_KeysPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "fieldsByKeys";

        private Fields_By_KeysPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class GetIssueNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetIssueNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Properties
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Properties() {
        }

        Properties(String text) {
            this.text = text;
        }
    }

    private static final class PropertiesEnabledRef
    implements BooleanReference {
        private PropertiesEnabledRef() {
        }
    }

    private static final class PropertiesPersistor
    implements NodeParametersPersistor<Properties[]> {
        static final String CONFIG_KEY = "properties";

        private PropertiesPersistor() {
        }

        public Properties[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Properties[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Properties::new).toArray(Properties[]::new);
        }

        public void save(Properties[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class UpdateHistoryEnabledRef
    implements BooleanReference {
        private UpdateHistoryEnabledRef() {
        }
    }

    private static final class Update_HistoryPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "updateHistory";

        private Update_HistoryPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }
}

