/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3.operation.searchforissuesusingjql;

import com.nodepit.nodes.jira.v3.HttpRequestNodeParameters;
import com.nodepit.nodes.jira.v3.NodeParametersUtils;
import com.nodepit.nodes.jira.v3.ResponseMapper;
import com.nodepit.nodes.jira.v3.SimpleResponseMapper;
import com.nodepit.nodes.jira.v3.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.number.NumberInputWidget;

class SearchForIssuesUsingJqlNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set JQL", description="Enable to set the optional field <b>JQL</b>")
    @ValueReference(value=JqlEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean jqlEnabled = false;
    @Widget(title="JQL", description="\t<p>The <a href=\"https://confluence.atlassian.com/x/egORLQ\">JQL</a> that defines the search. Note:</p>\n<ul>\n<li>If no JQL expression is provided, all issues are returned.</li>\n<li><tt>username</tt> and <tt>userkey</tt> cannot be used as search terms due to privacy reasons. Use <tt>accountId</tt> instead.</li>\n<li>If a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=JqlEnabledRef.class, type=Effect.EffectType.SHOW)
    String jql = null;
    @Widget(title="Set Start At", description="Enable to set the optional field <b>Start At</b>")
    @ValueReference(value=StartAtEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean startAtEnabled = false;
    @Widget(title="Start At", description="The index of the first item to return in a page of results (page offset).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=StartAtEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int startAt = 0;
    @Widget(title="Set Max Results", description="Enable to set the optional field <b>Max Results</b>")
    @ValueReference(value=MaxResultsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean maxResultsEnabled = false;
    @Widget(title="Max Results", description="The maximum number of items to return per page. To manage page size, Jira may return fewer items per page where a large number of fields or properties are requested. The greatest number of items returned per page is achieved when requesting <tt>id</tt> or <tt>key</tt> only.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=MaxResultsEnabledRef.class, type=Effect.EffectType.SHOW)
    @NumberInputWidget
    int maxResults = 50;
    @Widget(title="Set Validate Query", description="Enable to set the optional field <b>Validate Query</b>")
    @ValueReference(value=ValidateQueryEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean validateQueryEnabled = false;
    @Widget(title="Validate Query", description="\t<p>Determines how to validate the JQL query and treat the validation results. Supported values are:</p>\n<ul>\n<li><tt>strict</tt> Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).</li>\n<li><tt>warn</tt> Returns all errors as warnings.</li>\n<li><tt>none</tt> No validation is performed.</li>\n<li><tt>true</tt> <i>Deprecated</i> A legacy synonym for <tt>strict</tt>.</li>\n<li><tt>false</tt> <i>Deprecated</i> A legacy synonym for <tt>warn</tt>.</li>\n</ul>\n<p>Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the <tt>validateQuery</tt> value.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ValidateQueryEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=Validate_QueryChoicesProvider.class)
    String validateQuery = "strict";
    private static final String[] VALIDATE_QUERY_VALUES = new String[]{"strict", "warn", "none", "true", "false"};
    @Widget(title="Set Fields", description="Enable to set the optional field <b>Fields</b>")
    @ValueReference(value=FieldsEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsEnabled = false;
    @Widget(title="Fields", description="\t<p>A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:</p>\n<ul>\n<li><tt>*all</tt> Returns all fields.</li>\n<li><tt>*navigable</tt> Returns navigable fields.</li>\n<li>Any issue field, prefixed with a minus to exclude.</li>\n</ul>\n<p>Examples:</p>\n<ul>\n<li><tt>summary,comment</tt> Returns only the summary and comments fields.</li>\n<li><tt>-description</tt> Returns all navigable (default) fields except description.</li>\n<li><tt>*all,-comment</tt> Returns all fields except comments.</li>\n</ul>\n<p>This parameter may be specified multiple times. For example, <tt>fields=field1,field2&amp;fields=field3</tt>.</p>\n<p>Note: All navigable fields are returned by default. This differs from <a href=\"#api-rest-api-3-issue-issueIdOrKey-get\">GET issue</a> where the default is all fields.</p>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=FieldsPersistor.class)
    Fields[] fields = new Fields[]{new Fields(null)};
    @Widget(title="Set Expand", description="Enable to set the optional field <b>Expand</b>")
    @ValueReference(value=ExpandEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean expandEnabled = false;
    @Widget(title="Expand", description="\t<p>Use <a href=\"#expansion\">expand</a> to include additional information about issues in the response. This parameter accepts a comma-separated list. Expand options include:</p>\n<ul>\n<li><tt>renderedFields</tt> Returns field values rendered in HTML format.</li>\n<li><tt>names</tt> Returns the display name of each field.</li>\n<li><tt>schema</tt> Returns the schema describing a field type.</li>\n<li><tt>transitions</tt> Returns all possible transitions for the issue.</li>\n<li><tt>operations</tt> Returns all possible operations for the issue.</li>\n<li><tt>editmeta</tt> Returns information about how each field can be edited.</li>\n<li><tt>changelog</tt> Returns a list of recent updates to an issue, sorted by date, starting from the most recent.</li>\n<li><tt>versionedRepresentations</tt> Instead of <tt>fields</tt>, returns <tt>versionedRepresentations</tt> a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.</li>\n</ul>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=ExpandEnabledRef.class, type=Effect.EffectType.SHOW)
    String expand = null;
    @Widget(title="Set Properties", description="Enable to set the optional field <b>Properties</b>")
    @ValueReference(value=PropertiesEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean propertiesEnabled = false;
    @Widget(title="Properties", description="A list of issue property keys for issue properties to include in the results. This parameter accepts a comma-separated list. Multiple properties can also be provided using an ampersand separated list. For example, <tt>properties=prop1,prop2&amp;properties=prop3</tt>. A maximum of 5 issue property keys can be specified.\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PropertiesEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=PropertiesPersistor.class)
    Properties[] properties = new Properties[]{new Properties(null)};
    @Widget(title="Set Fields by Keys", description="Enable to set the optional field <b>Fields by Keys</b>")
    @ValueReference(value=FieldsByKeysEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsByKeysEnabled = false;
    @Widget(title="Fields by Keys", description="Reference fields by their key (rather than ID).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsByKeysEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fields_By_KeysPersistor.class)
    String fieldsByKeys = "false";
    @Widget(title="Set Fail Fast", description="Enable to set the optional field <b>Fail Fast</b>")
    @ValueReference(value=FailFastEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean failFastEnabled = false;
    @Widget(title="Fail Fast", description="Whether to fail the request quickly in case of an error while loading fields for an issue. For <tt>failFast=true</tt>, if one field fails, the entire operation fails. For <tt>failFast=false</tt>, the operation will continue even if a field fails. It will return a valid response, but without values for the failed field(s).\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FailFastEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=NodeParametersUtils.BooleanChoicesProvider.class)
    @Persistor(value=Fail_FastPersistor.class)
    String failFast = "false";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Changelog:</b> Details of changelogs associated with the issue.</li>\n\t<li><b>Editmeta:</b> The metadata for the fields on the issue that can be amended.</li>\n\t<li><b>Expand:</b> Expand options that include additional issue details in the response.</li>\n\t<li><b>Fields:</b> </li>\n\t<li><b>Fields to Include:</b> </li>\n\t<li><b>Id:</b> The ID of the issue.</li>\n\t<li><b>Key:</b> The key of the issue.</li>\n\t<li><b>Names:</b> The ID and name of each field present on the issue.</li>\n\t<li><b>Operations:</b> The operations that can be performed on the issue.</li>\n\t<li><b>Properties:</b> Details of the issue properties identified in the request.</li>\n\t<li><b>Rendered Fields:</b> The rendered value of each field present on the issue.</li>\n\t<li><b>Schema:</b> The schema describing each field present on the issue.</li>\n\t<li><b>Self:</b> The URL of the issue details.</li>\n\t<li><b>Transitions:</b> The transitions that can be performed on the issue.</li>\n\t<li><b>Versioned Representations:</b> The versions of each field on the issue.</li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=SearchForIssuesUsingJqlNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"issues\":{\"*\":{\"changelog\":\"rows[#2][0]\",\"editmeta\":\"rows[#2][1]\",\"expand\":\"rows[#2][2]\",\"fields\":\"rows[#2][3]\",\"fieldsToInclude\":\"rows[#2][4]\",\"id\":\"rows[#2][5]\",\"key\":\"rows[#2][6]\",\"names\":\"rows[#2][7]\",\"operations\":\"rows[#2][8]\",\"properties\":\"rows[#2][9]\",\"renderedFields\":\"rows[#2][10]\",\"schema\":\"rows[#2][11]\",\"self\":\"rows[#2][12]\",\"transitions\":\"rows[#2][13]\",\"versionedRepresentations\":\"rows[#2][14]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Changelog", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Editmeta", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Expand", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Fields to Include", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Key", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Names", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Operations", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Properties", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Rendered Fields", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Schema", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Self", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Transitions", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Versioned Representations", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    SearchForIssuesUsingJqlNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.jqlEnabled) {
            params.add(new HttpRequestNodeParameters.Param("jql", this.jql));
        }
        if (this.startAtEnabled) {
            params.add(new HttpRequestNodeParameters.Param("startAt", this.startAt));
        }
        if (this.maxResultsEnabled) {
            params.add(new HttpRequestNodeParameters.Param("maxResults", this.maxResults));
        }
        if (this.validateQueryEnabled) {
            params.add(new HttpRequestNodeParameters.Param("validateQuery", this.validateQuery));
        }
        if (this.fieldsEnabled) {
            Arrays.stream(this.fields).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields", value.text));
            });
        }
        if (this.expandEnabled) {
            params.add(new HttpRequestNodeParameters.Param("expand", this.expand));
        }
        if (this.propertiesEnabled) {
            Arrays.stream(this.properties).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("properties", value.text));
            });
        }
        if (this.fieldsByKeysEnabled) {
            params.add(new HttpRequestNodeParameters.Param("fieldsByKeys", this.fieldsByKeys));
        }
        if (this.failFastEnabled) {
            params.add(new HttpRequestNodeParameters.Param("failFast", this.failFast));
        }
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class ExpandEnabledRef
    implements BooleanReference {
        private ExpandEnabledRef() {
        }
    }

    private static final class FailFastEnabledRef
    implements BooleanReference {
        private FailFastEnabledRef() {
        }
    }

    private static final class Fail_FastPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "failFast";

        private Fail_FastPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    static final class Fields
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Fields() {
        }

        Fields(String text) {
            this.text = text;
        }
    }

    private static final class FieldsByKeysEnabledRef
    implements BooleanReference {
        private FieldsByKeysEnabledRef() {
        }
    }

    private static final class FieldsEnabledRef
    implements BooleanReference {
        private FieldsEnabledRef() {
        }
    }

    private static final class FieldsPersistor
    implements NodeParametersPersistor<Fields[]> {
        static final String CONFIG_KEY = "fields";

        private FieldsPersistor() {
        }

        public Fields[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields::new).toArray(Fields[]::new);
        }

        public void save(Fields[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class Fields_By_KeysPersistor
    extends NodeParametersUtils.BooleanChoicesPersistor {
        static final String CONFIG_KEY = "fieldsByKeys";

        private Fields_By_KeysPersistor() {
        }

        @Override
        public String getConfigKey() {
            return CONFIG_KEY;
        }
    }

    private static final class JqlEnabledRef
    implements BooleanReference {
        private JqlEnabledRef() {
        }
    }

    private static final class MaxResultsEnabledRef
    implements BooleanReference {
        private MaxResultsEnabledRef() {
        }
    }

    static final class Properties
    implements WidgetGroup {
        @Widget(title="", description="")
        String text;

        Properties() {
        }

        Properties(String text) {
            this.text = text;
        }
    }

    private static final class PropertiesEnabledRef
    implements BooleanReference {
        private PropertiesEnabledRef() {
        }
    }

    private static final class PropertiesPersistor
    implements NodeParametersPersistor<Properties[]> {
        static final String CONFIG_KEY = "properties";

        private PropertiesPersistor() {
        }

        public Properties[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Properties[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Properties::new).toArray(Properties[]::new);
        }

        public void save(Properties[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class SearchForIssuesUsingJqlNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private SearchForIssuesUsingJqlNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class StartAtEnabledRef
    implements BooleanReference {
        private StartAtEnabledRef() {
        }
    }

    private static final class ValidateQueryEnabledRef
    implements BooleanReference {
        private ValidateQueryEnabledRef() {
        }
    }

    private static final class Validate_QueryChoicesProvider
    implements StringChoicesProvider {
        private Validate_QueryChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(VALIDATE_QUERY_VALUES);
        }
    }
}

