/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.jira.v3;

import com.nodepit.nodes.jira.v3.CountingRequestBody;
import com.nodepit.nodes.jira.v3.HttpRequestNodeParameters;
import com.nodepit.nodes.jira.v3.Utils;
import com.nodepit.nodes.jira.v3.port.ConfigPortObjectSpec;
import java.io.IOException;
import java.util.List;
import okhttp3.Call;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.KNIMEException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.node.DefaultModel;

public final class HttpRequestNodeModel {
    public static DefaultModel.ExecuteConsumer buildExecute(String method, String path) {
        return (input, output) -> {
            final HttpRequestNodeParameters modelParameters = (HttpRequestNodeParameters)input.getParameters();
            ExecutionContext exec = input.getExecutionContext();
            String loggerName = String.format("%s[%s %s]", HttpRequestNodeModel.class.getName(), method, path);
            NodeLogger logger = NodeLogger.getLogger((String)loggerName);
            try {
                ConfigPortObjectSpec configPortObjectSpec = input.getInPortObjects().length == 0 ? ConfigPortObjectSpec.DEFAULT : (ConfigPortObjectSpec)input.getInPortObject(0).getSpec();
                String assignedPath = path;
                for (HttpRequestNodeParameters.Param pathParam : modelParameters.getPathParams()) {
                    assignedPath = assignedPath.replace(String.format("{%s}", pathParam.name()), Utils.encodeUrlPathComponent(String.valueOf(pathParam.value())));
                }
                String serverUrl = configPortObjectSpec.getUrl();
                HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(serverUrl + assignedPath)).newBuilder();
                for (HttpRequestNodeParameters.Param queryParam : modelParameters.getQueryParams()) {
                    urlBuilder.addQueryParameter(queryParam.name(), String.valueOf(queryParam.value()));
                }
                HttpUrl url = urlBuilder.build();
                RequestBody requestBody = RequestBody.create((byte[])new byte[0], null);
                if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.NONE) {
                    requestBody = null;
                } else if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.FORM) {
                    bodyBuilder = new FormBody.Builder();
                    for (HttpRequestNodeParameters.Param bodyParam : modelParameters.getBodyParams()) {
                        bodyBuilder.add(bodyParam.name(), String.valueOf(bodyParam.value()));
                    }
                    requestBody = bodyBuilder.build();
                } else if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                    bodyBuilder = new MultipartBody.Builder();
                    bodyBuilder.setType(MultipartBody.FORM);
                    for (HttpRequestNodeParameters.Param bodyParam : modelParameters.getBodyParams()) {
                        Object object = bodyParam.value();
                        if (object instanceof HttpRequestNodeParameters.File) {
                            HttpRequestNodeParameters.File fileValue = (HttpRequestNodeParameters.File)object;
                            bodyBuilder.addFormDataPart(bodyParam.name(), fileValue.getFilename(), fileValue.getRequestBody());
                            continue;
                        }
                        bodyBuilder.addFormDataPart(bodyParam.name(), String.valueOf(bodyParam.value()));
                    }
                    requestBody = bodyBuilder.build();
                } else if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.JSON) {
                    requestBody = RequestBody.create((String)modelParameters.getJsonBody(), (MediaType)MediaType.parse((String)"application/json"));
                }
                OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
                configPortObjectSpec.addInterceptors(clientBuilder);
                HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(arg_0 -> ((NodeLogger)logger).debug(arg_0));
                if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                    loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.HEADERS);
                } else {
                    loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                }
                clientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
                if (!modelParameters.getCookieParams().isEmpty()) {
                    clientBuilder.cookieJar(new CookieJar(){

                        public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
                        }

                        public List<Cookie> loadForRequest(HttpUrl url) {
                            return modelParameters.getCookieParams().stream().map(p -> new Cookie.Builder().name(p.name()).value(String.valueOf(p.value())).build()).toList();
                        }
                    });
                }
                Request.Builder requestBuilder = new Request.Builder();
                requestBuilder.method(method, requestBody);
                requestBuilder.url(url);
                exec.setProgress("Sending request");
                if (modelParameters.getBodyType() == HttpRequestNodeParameters.BodyType.MULTIPART) {
                    ExecutionMonitor uploadProgress = exec.createSubProgress(0.5);
                    requestBody = new CountingRequestBody(requestBody, (bytesWritten, contentLength) -> uploadProgress.setProgress((double)bytesWritten / (double)contentLength, () -> Utils.humanReadableByteCountSI(bytesWritten) + " / " + Utils.humanReadableByteCountSI(contentLength)));
                }
                if (modelParameters.getResponseType() != null && !modelParameters.getResponseType().isEmpty()) {
                    requestBuilder.header("accept", modelParameters.getResponseType());
                }
                for (HttpRequestNodeParameters.Param headerParam : modelParameters.getHeaderParams()) {
                    requestBuilder.header(headerParam.name(), String.valueOf(headerParam.value()));
                }
                Request request = requestBuilder.build();
                OkHttpClient client = clientBuilder.build();
                Call call = client.newCall(request);
                exec.setProgress("Receiving response");
                Response response = call.execute();
                if (!response.isSuccessful()) {
                    String message = "Encountered HTTP status " + response.code();
                    String bodyString = response.body().string();
                    if (bodyString != null && !bodyString.isEmpty()) {
                        message = message + ": " + bodyString;
                    }
                    throw new IOException(message);
                }
                BufferedDataTable responseTable = modelParameters.getResponseMapper().getTable(exec, response, modelParameters.getResponseType());
                output.setOutData(0, (PortObject)responseTable);
                if (input.getInPortObjects().length > 0) {
                    output.setOutData(1, input.getInPortObject(0));
                }
            }
            catch (IOException e) {
                throw new KNIMEException(e.getMessage(), (Throwable)e);
            }
        };
    }

    public static void configure(DefaultModel.ConfigureInput input, DefaultModel.ConfigureOutput output) {
        HttpRequestNodeParameters modelParameters = (HttpRequestNodeParameters)input.getParameters();
        DataTableSpec responseSpec = modelParameters.getResponseMapper().getSpec(modelParameters.getResponseType());
        output.setOutSpec(0, (PortObjectSpec)responseSpec);
        if (input.getInPortSpecs().length > 0) {
            output.setOutSpec(1, input.getInPortSpec(0));
        }
    }

    private HttpRequestNodeModel() {
    }
}

