/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.bulksubscribeprofiles;

import com.nodepit.nodes.klaviyo.HttpRequestNodeModel;
import com.nodepit.nodes.klaviyo.operation.bulksubscribeprofiles.BulkSubscribeProfilesNodeParameters;
import com.nodepit.nodes.klaviyo.port.ConfigPortObject;
import org.knime.core.node.NodeFactory;
import org.knime.node.DefaultNode;
import org.knime.node.DefaultNodeFactory;
import org.knime.node.RequirePorts;

public class BulkSubscribeProfilesNodeFactory
extends DefaultNodeFactory {
    private static final DefaultNode NODE = DefaultNode.create().name("Bulk Subscribe Profiles").icon("../../node.png").shortDescription("Bulk Subscribe Profiles").fullDescription("\t\t\t<p>Subscribe one or more profiles to email marketing, SMS marketing, or both. If the provided list has double opt-in enabled, profiles will receive a message requiring their confirmation before subscribing. Otherwise, profiles will be immediately subscribed without receiving a confirmation message.\nLearn more about <a href=\"https://developers.klaviyo.com/en/docs/collect_email_and_sms_consent_via_api\">consent in this guide</a>.</p>\n<p>If a list is not provided, the opt-in process used will be determined by the <a href=\"https://www.klaviyo.com/settings/account/api-keys\">account-level default opt-in setting</a>.</p>\n<p>To add someone to a list without changing their subscription status, use <a href=\"https://developers.klaviyo.com/en/reference/create_list_relationships\">Add Profile to List</a>.</p>\n<p>This API will remove any <tt>UNSUBSCRIBE</tt>, <tt>SPAM_REPORT</tt> or <tt>USER_SUPPRESSED</tt> suppressions from the provided profiles. Learn more about <a href=\"https://help.klaviyo.com/hc/en-us/articles/115005246108-Understanding-suppressed-email-profiles#what-is-a-suppressed-profile-1\">suppressed profiles</a>.</p>\n<p>Maximum number of profiles can be submitted for subscription: 1000</p>\n<p>This endpoint now supports a <tt>historical_import</tt> flag. If this flag is set <tt>true</tt>, profiles being subscribed will bypass double opt-in emails and be subscribed immediately. They will also bypass any associated &quot;Added to list&quot; flows. This is useful for importing historical data where you have already collected consent. If <tt>historical_import</tt> is set to true, the <tt>consented_at</tt> field is required and must be in the past.<br/><br/><i>Rate limits</i>:<br/>Burst: <tt>75/s</tt><br/>Steady: <tt>700/m</tt></p>\n<p><b>Scopes:</b>\n<tt>lists:write</tt>\n<tt>profiles:write</tt>\n<tt>subscriptions:write</tt></p>\n").sinceVersion(5, 7, 0).ports(ports -> {
        RequirePorts.PortsAdder portsAdder = ports.addInputPort("Configuration Input", "Configuration data.", ConfigPortObject.TYPE).addOutputTable("Result", "Result of the request depending on the selected <b>Result Format</b>.").addOutputPort("Configuration Output", "Configuration data (this is the same as the input port; it is provided as passthrough for sequentially chaining nodes to declutter your workflow connections).", ConfigPortObject.TYPE);
    }).model(model -> model.parametersClass(BulkSubscribeProfilesNodeParameters.class).configure(HttpRequestNodeModel::configure).execute(HttpRequestNodeModel.buildExecute("POST", "/api/profile-subscription-bulk-create-jobs"))).nodeType(NodeFactory.NodeType.Other).keywords(new String[]{"bulk_subscribe_profiles", "POST /api/profile-subscription-bulk-create-jobs"});

    public BulkSubscribeProfilesNodeFactory() {
        super(NODE);
    }
}

