/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.createprofile;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class CreateProfileNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Additional Fields[profile]", description="Enable to set the optional field <b>Additional Fields[profile]</b>")
    @ValueReference(value=AdditionalFieldsProfileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean additionalFieldsProfileEnabled = false;
    @Widget(title="Additional Fields[profile]", description="Request additional fields not included by default in the response. Supported values: 'subscriptions', 'predictive_analytics'\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=AdditionalFieldsProfileEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Additional_Fields_ProfilePersistor.class)
    Additional_Fields_Profile[] additionalFieldsProfile = new Additional_Fields_Profile[]{new Additional_Fields_Profile(ADDITIONAL_FIELDS_PROFILE_VALUES[0])};
    private static final String[] ADDITIONAL_FIELDS_PROFILE_VALUES = new String[]{"subscriptions", "predictive_analytics"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Body", description="\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String body = null;
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> Primary key that uniquely identifies this profile. Generated by Klaviyo.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Relationships:</b> </li>\n\t<li><b>Links:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=CreateProfileNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"attributes\":\"rows[0][2]\",\"relationships\":\"rows[0][3]\",\"links\":\"rows[0][4]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    CreateProfileNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.additionalFieldsProfileEnabled) {
            Arrays.stream(this.additionalFieldsProfile).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("additional-fields[profile]", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class AdditionalFieldsProfileEnabledRef
    implements BooleanReference {
        private AdditionalFieldsProfileEnabledRef() {
        }
    }

    static final class Additional_Fields_Profile
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Additional_Fields_ProfileChoicesProvider.class)
        String text;

        Additional_Fields_Profile() {
        }

        Additional_Fields_Profile(String text) {
            this.text = text;
        }

        private static final class Additional_Fields_ProfileChoicesProvider
        implements StringChoicesProvider {
            private Additional_Fields_ProfileChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(ADDITIONAL_FIELDS_PROFILE_VALUES);
            }
        }
    }

    private static final class Additional_Fields_ProfilePersistor
    implements NodeParametersPersistor<Additional_Fields_Profile[]> {
        static final String CONFIG_KEY = "additionalFieldsProfile";

        private Additional_Fields_ProfilePersistor() {
        }

        public Additional_Fields_Profile[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Additional_Fields_Profile[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Additional_Fields_Profile::new).toArray(Additional_Fields_Profile[]::new);
        }

        public void save(Additional_Fields_Profile[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class CreateProfileNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private CreateProfileNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }
}

