/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getcatalogcategories;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetCatalogCategoriesNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Fields[catalog Category]", description="Enable to set the optional field <b>Fields[catalog Category]</b>")
    @ValueReference(value=FieldsCatalogCategoryEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsCatalogCategoryEnabled = false;
    @Widget(title="Fields[catalog Category]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsCatalogCategoryEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Catalog_CategoryPersistor.class)
    Fields_Catalog_Category[] fieldsCatalogCategory = new Fields_Catalog_Category[]{new Fields_Catalog_Category(FIELDS_CATALOG_CATEGORY_VALUES[0])};
    private static final String[] FIELDS_CATALOG_CATEGORY_VALUES = new String[]{"external_id", "name", "updated"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>ids</tt>: <tt>any</tt><br/><tt>item.id</tt>: <tt>equals</tt><br/><tt>name</tt>: <tt>contains</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"created", "-created"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The catalog category ID is a compound ID (string), with format: <tt>{integration}:::{catalog}:::{external_id}</tt>. Currently, the only supported integration type is <tt>$custom</tt>, and the only supported catalog is <tt>$default</tt>.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetCatalogCategoriesNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetCatalogCategoriesNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsCatalogCategoryEnabled) {
            Arrays.stream(this.fieldsCatalogCategory).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[catalog-category]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsCatalogCategoryEnabledRef
    implements BooleanReference {
        private FieldsCatalogCategoryEnabledRef() {
        }
    }

    static final class Fields_Catalog_Category
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Catalog_CategoryChoicesProvider.class)
        String text;

        Fields_Catalog_Category() {
        }

        Fields_Catalog_Category(String text) {
            this.text = text;
        }

        private static final class Fields_Catalog_CategoryChoicesProvider
        implements StringChoicesProvider {
            private Fields_Catalog_CategoryChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_CATALOG_CATEGORY_VALUES);
            }
        }
    }

    private static final class Fields_Catalog_CategoryPersistor
    implements NodeParametersPersistor<Fields_Catalog_Category[]> {
        static final String CONFIG_KEY = "fieldsCatalogCategory";

        private Fields_Catalog_CategoryPersistor() {
        }

        public Fields_Catalog_Category[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Catalog_Category[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Catalog_Category::new).toArray(Fields_Catalog_Category[]::new);
        }

        public void save(Fields_Catalog_Category[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetCatalogCategoriesNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetCatalogCategoriesNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

