/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getcatalogitems;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetCatalogItemsNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Set Fields[catalog Item]", description="Enable to set the optional field <b>Fields[catalog Item]</b>")
    @ValueReference(value=FieldsCatalogItemEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsCatalogItemEnabled = false;
    @Widget(title="Fields[catalog Item]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsCatalogItemEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Catalog_ItemPersistor.class)
    Fields_Catalog_Item[] fieldsCatalogItem = new Fields_Catalog_Item[]{new Fields_Catalog_Item(FIELDS_CATALOG_ITEM_VALUES[0])};
    private static final String[] FIELDS_CATALOG_ITEM_VALUES = new String[]{"external_id", "title", "description", "price", "url", "image_full_url", "image_thumbnail_url", "images", "custom_metadata", "published", "created", "updated"};
    @Widget(title="Set Fields[catalog Variant]", description="Enable to set the optional field <b>Fields[catalog Variant]</b>")
    @ValueReference(value=FieldsCatalogVariantEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsCatalogVariantEnabled = false;
    @Widget(title="Fields[catalog Variant]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsCatalogVariantEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_Catalog_VariantPersistor.class)
    Fields_Catalog_Variant[] fieldsCatalogVariant = new Fields_Catalog_Variant[]{new Fields_Catalog_Variant(FIELDS_CATALOG_VARIANT_VALUES[0])};
    private static final String[] FIELDS_CATALOG_VARIANT_VALUES = new String[]{"external_id", "title", "description", "sku", "inventory_policy", "inventory_quantity", "price", "url", "image_full_url", "image_thumbnail_url", "images", "custom_metadata", "published", "created", "updated"};
    @Widget(title="Set Filter", description="Enable to set the optional field <b>Filter</b>")
    @ValueReference(value=FilterEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean filterEnabled = false;
    @Widget(title="Filter", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#filtering<br/>Allowed field(s)/operator(s):<br/><tt>ids</tt>: <tt>any</tt><br/><tt>category.id</tt>: <tt>equals</tt><br/><tt>title</tt>: <tt>contains</tt><br/><tt>published</tt>: <tt>equals</tt>\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FilterEnabledRef.class, type=Effect.EffectType.SHOW)
    String filter = null;
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"variants"};
    @Widget(title="Set Page[cursor]", description="Enable to set the optional field <b>Page[cursor]</b>")
    @ValueReference(value=PageCursorEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean pageCursorEnabled = false;
    @Widget(title="Page[cursor]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#pagination\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=PageCursorEnabledRef.class, type=Effect.EffectType.SHOW)
    String pageCursor = null;
    @Widget(title="Set Sort", description="Enable to set the optional field <b>Sort</b>")
    @ValueReference(value=SortEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean sortEnabled = false;
    @Widget(title="Sort", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sorting\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=SortEnabledRef.class, type=Effect.EffectType.SHOW)
    @ChoicesProvider(value=SortChoicesProvider.class)
    String sort = SORT_VALUES[0];
    private static final String[] SORT_VALUES = new String[]{"created", "-created"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The catalog item ID is a compound ID (string), with format: <tt>{integration}:::{catalog}:::{external_id}</tt>. Currently, the only supported integration type is <tt>$custom</tt>, and the only supported catalog is <tt>$default</tt>.</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetCatalogItemsNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"*\":{\"type\":\"rows[#2][0]\",\"id\":\"rows[#2][1]\",\"attributes\":\"rows[#2][2]\",\"links\":\"rows[#2][3]\",\"relationships\":\"rows[#2][4]\"}}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetCatalogItemsNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsCatalogItemEnabled) {
            Arrays.stream(this.fieldsCatalogItem).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[catalog-item]", value.text));
            });
        }
        if (this.fieldsCatalogVariantEnabled) {
            Arrays.stream(this.fieldsCatalogVariant).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[catalog-variant]", value.text));
            });
        }
        if (this.filterEnabled) {
            params.add(new HttpRequestNodeParameters.Param("filter", this.filter));
        }
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        if (this.pageCursorEnabled) {
            params.add(new HttpRequestNodeParameters.Param("page[cursor]", this.pageCursor));
        }
        if (this.sortEnabled) {
            params.add(new HttpRequestNodeParameters.Param("sort", this.sort));
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsCatalogItemEnabledRef
    implements BooleanReference {
        private FieldsCatalogItemEnabledRef() {
        }
    }

    private static final class FieldsCatalogVariantEnabledRef
    implements BooleanReference {
        private FieldsCatalogVariantEnabledRef() {
        }
    }

    static final class Fields_Catalog_Item
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Catalog_ItemChoicesProvider.class)
        String text;

        Fields_Catalog_Item() {
        }

        Fields_Catalog_Item(String text) {
            this.text = text;
        }

        private static final class Fields_Catalog_ItemChoicesProvider
        implements StringChoicesProvider {
            private Fields_Catalog_ItemChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_CATALOG_ITEM_VALUES);
            }
        }
    }

    private static final class Fields_Catalog_ItemPersistor
    implements NodeParametersPersistor<Fields_Catalog_Item[]> {
        static final String CONFIG_KEY = "fieldsCatalogItem";

        private Fields_Catalog_ItemPersistor() {
        }

        public Fields_Catalog_Item[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Catalog_Item[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Catalog_Item::new).toArray(Fields_Catalog_Item[]::new);
        }

        public void save(Fields_Catalog_Item[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Catalog_Variant
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_Catalog_VariantChoicesProvider.class)
        String text;

        Fields_Catalog_Variant() {
        }

        Fields_Catalog_Variant(String text) {
            this.text = text;
        }

        private static final class Fields_Catalog_VariantChoicesProvider
        implements StringChoicesProvider {
            private Fields_Catalog_VariantChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_CATALOG_VARIANT_VALUES);
            }
        }
    }

    private static final class Fields_Catalog_VariantPersistor
    implements NodeParametersPersistor<Fields_Catalog_Variant[]> {
        static final String CONFIG_KEY = "fieldsCatalogVariant";

        private Fields_Catalog_VariantPersistor() {
        }

        public Fields_Catalog_Variant[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Catalog_Variant[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Catalog_Variant::new).toArray(Fields_Catalog_Variant[]::new);
        }

        public void save(Fields_Catalog_Variant[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class FilterEnabledRef
    implements BooleanReference {
        private FilterEnabledRef() {
        }
    }

    private static final class GetCatalogItemsNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetCatalogItemsNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class PageCursorEnabledRef
    implements BooleanReference {
        private PageCursorEnabledRef() {
        }
    }

    private static final class SortChoicesProvider
    implements StringChoicesProvider {
        private SortChoicesProvider() {
        }

        public List<String> choices(NodeParametersInput context) {
            return Arrays.asList(SORT_VALUES);
        }
    }

    private static final class SortEnabledRef
    implements BooleanReference {
        private SortEnabledRef() {
        }
    }
}

