/*
 * Decompiled with CFR 0.152.
 */
package com.nodepit.nodes.klaviyo.operation.getevent;

import com.nodepit.nodes.klaviyo.HttpRequestNodeParameters;
import com.nodepit.nodes.klaviyo.NodeParametersUtils;
import com.nodepit.nodes.klaviyo.ResponseMapper;
import com.nodepit.nodes.klaviyo.SimpleResponseMapper;
import com.nodepit.nodes.klaviyo.TransformToTableMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.def.StringCell;
import org.knime.core.data.json.JSONCellFactory;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.node.parameters.NodeParametersInput;
import org.knime.node.parameters.Widget;
import org.knime.node.parameters.WidgetGroup;
import org.knime.node.parameters.array.ArrayWidget;
import org.knime.node.parameters.migration.Migrate;
import org.knime.node.parameters.migration.Migration;
import org.knime.node.parameters.persistence.NodeParametersPersistor;
import org.knime.node.parameters.persistence.Persistor;
import org.knime.node.parameters.updates.Effect;
import org.knime.node.parameters.updates.ValueReference;
import org.knime.node.parameters.updates.util.BooleanReference;
import org.knime.node.parameters.widget.choices.ChoicesProvider;
import org.knime.node.parameters.widget.choices.StringChoicesProvider;
import org.knime.node.parameters.widget.text.TextInputWidget;
import org.knime.node.parameters.widget.text.TextInputWidgetValidation;

class GetEventNodeParameters
implements HttpRequestNodeParameters {
    @Widget(title="Id", description="ID of the event\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String id = null;
    @Widget(title="Set Fields[event]", description="Enable to set the optional field <b>Fields[event]</b>")
    @ValueReference(value=FieldsEventEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsEventEnabled = false;
    @Widget(title="Fields[event]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsEventEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_EventPersistor.class)
    Fields_Event[] fieldsEvent = new Fields_Event[]{new Fields_Event(FIELDS_EVENT_VALUES[0])};
    private static final String[] FIELDS_EVENT_VALUES = new String[]{"timestamp", "event_properties", "datetime", "uuid"};
    @Widget(title="Set Fields[metric]", description="Enable to set the optional field <b>Fields[metric]</b>")
    @ValueReference(value=FieldsMetricEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsMetricEnabled = false;
    @Widget(title="Fields[metric]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsMetricEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_MetricPersistor.class)
    Fields_Metric[] fieldsMetric = new Fields_Metric[]{new Fields_Metric(FIELDS_METRIC_VALUES[0])};
    private static final String[] FIELDS_METRIC_VALUES = new String[]{"name", "created", "updated", "integration"};
    @Widget(title="Set Fields[profile]", description="Enable to set the optional field <b>Fields[profile]</b>")
    @ValueReference(value=FieldsProfileEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean fieldsProfileEnabled = false;
    @Widget(title="Fields[profile]", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#sparse-fieldsets\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=FieldsProfileEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=Fields_ProfilePersistor.class)
    Fields_Profile[] fieldsProfile = new Fields_Profile[]{new Fields_Profile(FIELDS_PROFILE_VALUES[0])};
    private static final String[] FIELDS_PROFILE_VALUES = new String[]{"email", "phone_number", "external_id", "first_name", "last_name", "organization", "locale", "title", "image", "created", "updated", "last_event_date", "location", "location.address1", "location.address2", "location.city", "location.country", "location.latitude", "location.longitude", "location.region", "location.zip", "location.timezone", "location.ip", "properties"};
    @Widget(title="Set Include", description="Enable to set the optional field <b>Include</b>")
    @ValueReference(value=IncludeEnabledRef.class)
    @Migrate(loadDefaultIfAbsent=true)
    boolean includeEnabled = false;
    @Widget(title="Include", description="For more information please visit https://developers.klaviyo.com/en/v2025-07-15/reference/api-overview#relationships\n")
    @Migrate(loadDefaultIfAbsent=true)
    @Effect(predicate=IncludeEnabledRef.class, type=Effect.EffectType.SHOW)
    @ArrayWidget
    @Persistor(value=IncludePersistor.class)
    Include[] include = new Include[]{new Include(INCLUDE_VALUES[0])};
    private static final String[] INCLUDE_VALUES = new String[]{"attributions", "metric", "profile"};
    @Widget(title="Revision", description="API endpoint revision (format: YYYY-MM-DD[.suffix])\n")
    @Migrate(loadDefaultIfAbsent=true)
    @TextInputWidget(minLengthValidation=TextInputWidgetValidation.PatternValidation.IsNotEmptyValidation.class)
    String revision = "2025-07-15";
    @Widget(title="Result Format", description="<p>Specify how the response should be mapped to the table output. The following formats are available:</p>\n<p><b>Structured Table:</b> Returns a parsed table with data split into rows\nand columns.</p>\n<ul>\n\t<li><b>Type:</b> </li>\n\t<li><b>Id:</b> The Event ID</li>\n\t<li><b>Attributes:</b> </li>\n\t<li><b>Links:</b> </li>\n\t<li><b>Relationships:</b> </li>\n</ul>\n<p><b>Raw Response:</b> Returns the raw response in a single row with the following columns:</p>\n<ul>\n\t<li><b>body:</b> Response body</li>\n\t<li><b>status:</b> HTTP status code</li>\n</ul>\n")
    @Migration(value=NodeParametersUtils.ResponseMapperMigration.class)
    @ChoicesProvider(value=GetEventNodeParametersResponseMapperChoicesProvider.class)
    String resultFormat = MAPPERS[0].identifier();
    private static final ResponseMapper[] MAPPERS = new ResponseMapper[]{new TransformToTableMapper.Builder().useJoltMapping("[{\"operation\":\"shift\",\"spec\":{\"data\":{\"type\":\"rows[0][0]\",\"id\":\"rows[0][1]\",\"attributes\":\"rows[0][2]\",\"links\":\"rows[0][3]\",\"relationships\":\"rows[0][4]\"}}}]").addBodyColumn(new DataColumnSpecCreator("Type", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Id", StringCell.StringCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Attributes", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Links", JSONCellFactory.TYPE).createSpec()).addBodyColumn(new DataColumnSpecCreator("Relationships", JSONCellFactory.TYPE).createSpec()).build(), new SimpleResponseMapper.Builder().withBody().build()};

    GetEventNodeParameters() {
    }

    @Override
    public ResponseMapper getResponseMapper() {
        return Arrays.stream(MAPPERS).filter(m -> m.identifier().equals(this.resultFormat)).findFirst().orElseThrow();
    }

    public void validate() throws InvalidSettingsException {
        if (this.id == null || this.id.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cId\u201d is required.");
        }
        if (this.revision == null || this.revision.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cRevision\u201d is required.");
        }
        if (this.resultFormat == null || this.resultFormat.isEmpty()) {
            throw new InvalidSettingsException("Value for \u201cResult Format\u201d is required.");
        }
    }

    @Override
    public String getResponseType() {
        return "application/vnd.api+json";
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getPathParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("id", this.id));
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getQueryParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        if (this.fieldsEventEnabled) {
            Arrays.stream(this.fieldsEvent).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[event]", value.text));
            });
        }
        if (this.fieldsMetricEnabled) {
            Arrays.stream(this.fieldsMetric).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[metric]", value.text));
            });
        }
        if (this.fieldsProfileEnabled) {
            Arrays.stream(this.fieldsProfile).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("fields[profile]", value.text));
            });
        }
        if (this.includeEnabled) {
            Arrays.stream(this.include).forEach(value -> {
                boolean bl = params.add(new HttpRequestNodeParameters.Param("include", value.text));
            });
        }
        return params;
    }

    @Override
    public List<HttpRequestNodeParameters.Param> getHeaderParams() {
        ArrayList<HttpRequestNodeParameters.Param> params = new ArrayList<HttpRequestNodeParameters.Param>();
        params.add(new HttpRequestNodeParameters.Param("revision", this.revision));
        return params;
    }

    @Override
    public HttpRequestNodeParameters.BodyType getBodyType() {
        return HttpRequestNodeParameters.BodyType.NONE;
    }

    @Override
    public String getJsonBody() {
        return null;
    }

    private static final class FieldsEventEnabledRef
    implements BooleanReference {
        private FieldsEventEnabledRef() {
        }
    }

    private static final class FieldsMetricEnabledRef
    implements BooleanReference {
        private FieldsMetricEnabledRef() {
        }
    }

    private static final class FieldsProfileEnabledRef
    implements BooleanReference {
        private FieldsProfileEnabledRef() {
        }
    }

    static final class Fields_Event
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_EventChoicesProvider.class)
        String text;

        Fields_Event() {
        }

        Fields_Event(String text) {
            this.text = text;
        }

        private static final class Fields_EventChoicesProvider
        implements StringChoicesProvider {
            private Fields_EventChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_EVENT_VALUES);
            }
        }
    }

    private static final class Fields_EventPersistor
    implements NodeParametersPersistor<Fields_Event[]> {
        static final String CONFIG_KEY = "fieldsEvent";

        private Fields_EventPersistor() {
        }

        public Fields_Event[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Event[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Event::new).toArray(Fields_Event[]::new);
        }

        public void save(Fields_Event[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Metric
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_MetricChoicesProvider.class)
        String text;

        Fields_Metric() {
        }

        Fields_Metric(String text) {
            this.text = text;
        }

        private static final class Fields_MetricChoicesProvider
        implements StringChoicesProvider {
            private Fields_MetricChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_METRIC_VALUES);
            }
        }
    }

    private static final class Fields_MetricPersistor
    implements NodeParametersPersistor<Fields_Metric[]> {
        static final String CONFIG_KEY = "fieldsMetric";

        private Fields_MetricPersistor() {
        }

        public Fields_Metric[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Metric[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Metric::new).toArray(Fields_Metric[]::new);
        }

        public void save(Fields_Metric[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    static final class Fields_Profile
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=Fields_ProfileChoicesProvider.class)
        String text;

        Fields_Profile() {
        }

        Fields_Profile(String text) {
            this.text = text;
        }

        private static final class Fields_ProfileChoicesProvider
        implements StringChoicesProvider {
            private Fields_ProfileChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(FIELDS_PROFILE_VALUES);
            }
        }
    }

    private static final class Fields_ProfilePersistor
    implements NodeParametersPersistor<Fields_Profile[]> {
        static final String CONFIG_KEY = "fieldsProfile";

        private Fields_ProfilePersistor() {
        }

        public Fields_Profile[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Fields_Profile[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Fields_Profile::new).toArray(Fields_Profile[]::new);
        }

        public void save(Fields_Profile[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }

    private static final class GetEventNodeParametersResponseMapperChoicesProvider
    extends NodeParametersUtils.ResponseMapperChoicesProvider {
        private GetEventNodeParametersResponseMapperChoicesProvider() {
        }

        @Override
        public ResponseMapper[] getResponseMappers() {
            return MAPPERS;
        }
    }

    static final class Include
    implements WidgetGroup {
        @Widget(title="", description="")
        @ChoicesProvider(value=IncludeChoicesProvider.class)
        String text;

        Include() {
        }

        Include(String text) {
            this.text = text;
        }

        private static final class IncludeChoicesProvider
        implements StringChoicesProvider {
            private IncludeChoicesProvider() {
            }

            public List<String> choices(NodeParametersInput context) {
                return Arrays.asList(INCLUDE_VALUES);
            }
        }
    }

    private static final class IncludeEnabledRef
    implements BooleanReference {
        private IncludeEnabledRef() {
        }
    }

    private static final class IncludePersistor
    implements NodeParametersPersistor<Include[]> {
        static final String CONFIG_KEY = "include";

        private IncludePersistor() {
        }

        public Include[] load(NodeSettingsRO settings) throws InvalidSettingsException {
            return (Include[])Arrays.stream(settings.getStringArray(CONFIG_KEY)).map(Include::new).toArray(Include[]::new);
        }

        public void save(Include[] obj, NodeSettingsWO settings) {
            String[] stringArray = (String[])Arrays.stream(obj).map(s -> s.text).toArray(String[]::new);
            settings.addStringArray(CONFIG_KEY, stringArray);
        }

        public String[][] getConfigPaths() {
            return new String[][]{{CONFIG_KEY}};
        }
    }
}

